#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_lu_name, $arg_description, $arg_pu_name,$arg_nau_address,
    $arg_pool_name, $arg_lu_model, $arg_sscp_id, $arg_timeout, $description, 
    $pool_name, $type, $timeout, $sscp_id, $len, $time, $remote_addr, 
    $remote_port, $line, @data, @contents, @pulist, @retval);

$arg_lu_name="";
$arg_description="";
$arg_pu_name="";
$arg_pool_name="";
$arg_lu_model="UNKNOWN";
$arg_nau_address="2";
$arg_timeout="0";
$arg_sscp_id="0";
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_ls -d`;
foreach $line (@contents) {
     next if ($line=~m/-----/);   # Do not display seperaters
       
    if ($line=~m/dlc_type/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        $type=$data[1];
        next;
    }elsif ($line=~m/pu_name/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         if ($type=~m/ETHERNET/ ) {
           if($data[1]=~m/""/)
           {
              next;
           }else{
              push @pulist, $data[1];
              next;
           }
        }
    }
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlur_pu`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/pu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @pulist, $data[1];
        next;
    }
}
    
$len=@pulist;
if($len eq 0){
    print "<br> Host LS/DLUR PU should be defined before define LU Type 0-3. ";
    exit 1;
}
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    
  
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addlu3.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  LU name
print "<tr><td>* LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"lu0-3_name_unique\" maxlength=\"8\" value=\"$arg_lu_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9#@]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #  Host LS/DLUR PU
print "<tr><td>* Host LS/DLUR PU :</td> <td><select name=\"pu_name\" class=\"rightAligned\" value=\"$arg_pu_name\" >  ";
foreach $line (@pulist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #  * LU number
print "<tr><td>* LU number(1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"nau_address\" maxlength=\"3\" value=\"$arg_nau_address\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\"/></td></tr>";
    
    #   Model type
print "<tr><td> Model type :</td> <td> <select name=\"lu_model\" class=\"rightAligned\" value=\"$arg_lu_model\" >  ";
print "<option value=\"UNKNOWN\" selected=\"selected\">UNKNOWN</option> ";
print "<option value=\"3270_DISPLAY_MODEL_2\">3270_DISPLAY_MODEL_2</option>";
print "<option value=\"3270_DISPLAY_MODEL_3\">3270_DISPLAY_MODEL_3</option>";
print "<option value=\"3270_DISPLAY_MODEL_4\">3270_DISPLAY_MODEL_4</option>";
print "<option value=\"3270_DISPLAY_MODEL_5\">3270_DISPLAY_MODEL_5</option>";
print "<option value=\"PRINTER\">PRINTER</option>";
print "<option value=\"SCS_PRINTER\">SCS_PRINTER</option>";
print "<option value=\"RJE_WKSTN\">RJE_WKSTN</option></select></td></tr>";
    
    #   Pool name (if pooled)
print "<tr><td>Pool name (if pooled) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"pool_name\" maxlength=\"8\" value=\"$arg_pool_name\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.\$#@]/g,'')\" /></td></tr>";
    
    #   SSCP_ID
print "<tr><td>SSCP ID(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"sscp_id\" maxlength=\"5\" value=\"$arg_sscp_id\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Inactivity timeout
print "<tr><td>Inactivity timeout(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"timeout\" maxlength=\"5\" value=\"$arg_timeout\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

