#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_lu_name, $arg_description, $arg_wildcard_fqplu, 
    $arg_fq_partner_lu, $arg_ls_name, $ls_name,$description, 
    $fq_partner_lu, $time, $remote_addr, $remote_port, $line, 
    $len, @data, @contents, @list, @lslist, @retval);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_lu_name="";
$arg_description="";
$arg_fq_partner_lu="";
$arg_wildcard_fqplu="NO";
$arg_ls_name="";

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/lu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
    
$len=@list;
if($len eq 0){
   print "<br> Local LU should be defined. ";
   exit 1;
}
  
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_ls -d`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/ls_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        $ls_name=$data[1];
        next;
    }elsif ($line=~m/dlc_type/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        if ($data[1]=~m/ETHERNET/ ) {
           push @lslist, $ls_name;
        }
    }
}
    
$len=@lslist;
if($len eq 0){
    print "<br> Ethernet Link station should be defined. ";
    exit 1;
}
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_ls.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  * Local LU name
print "<tr><td>* Local LU name :</td> <td> <select name=\"lu_name_unique\" class=\"rightAligned\" value=\"$arg_lu_name\" >  ";
foreach $line (@list) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #   Fully-qualified partner LU name
print "<tr><td>Fully-qualified partner LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fq_partner_lu\" maxlength=\"17\" value=\"$arg_fq_partner_lu\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #  Partner name contains wildcards?
print "<tr><td>Partner name contains wildcards ? </td> <td><select name=\"wildcard_fqplu\" class=\"rightAligned\" value=\"$arg_wildcard_fqplu\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option></select></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #   * Link station name
print "<tr><td>* Link station name  : </td> <td><select name=\"ls_name\" class=\"rightAligned\" value=\"$arg_ls_name\" >  ";
foreach $line (@lslist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

