#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_ms_category, $arg_description, $arg_fp_fqcp_name, 
    $arg_ms_appl_name, $description, $ms_appl_name, $fp_fqcp_name, 
    $time, $remote_addr, $remote_port, $line, @data, @contents, @retval);


$arg_ms_category="";
$arg_description="";
$arg_fp_fqcp_name="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}

  
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addfocalpoint.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Fully qualified control point name
print "<tr> <td>Fully qualified control point name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"fp_fqcp_name\"  maxlength=\"17\" value=\"$arg_fp_fqcp_name\"/oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #    Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#.:@\$ ]/g,'')\" /></td></tr>";
    
    #   * Management Services category
print "<tr> <td>* Management Services category :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"ms_category_unique\"  maxlength=\"8\" value=\"$arg_ms_category\" required=\"required\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    # Focal point application name
print "<tr> <td>Focal point application name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"ms_appl_name\"  maxlength=\"8\" value=\"$arg_ms_appl_name\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

