#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_eth_ls_name, $arg_description, $arg_initially_active,
    $arg_port_name, $arg_adj_cp_name, $arg_adj_cp_type,$arg_dspu_services, 
    $arg_dspu_name, $arg_dlus_name, $arg_local_node_id,$arg_adj_node_id,
    $arg_conventional_lu_compression,$arg_mac_address,$arg_lsap_address, 
    $arg_ls_attributes,$arg_cp_cp_sess_support,$arg_hpr_supported, 
    $arg_hpr_link_lvl_error, $arg_tg_number,$arg_solicit_sscp_sessions, 
    $arg_max_send_btu_size, $arg_default_nn_server,$arg_ls_role, 
    $arg_branch_link_type, $arg_xid_timer_retry,$arg_restart_on_normal_deact, 
    $description, $port_name, $len,$tg_number, $lsap_address,$max_send_btu_size, 
    $adj_cp_name,$dspu_name, $dlus_name,$local_node_id,$adj_node_id,$mac_address, 
    $xid_timer_retry, $time, $remote_addr, $remote_port, $line, @data, 
    @contents, @portlist, @retval);

$arg_eth_ls_name="";
$arg_description="";
$arg_port_name="";
$arg_initially_active="NO";
$arg_adj_cp_name="";
$arg_adj_cp_type="LEARN_NODE";
$arg_dspu_services="NONE";
$arg_dspu_name="";
$arg_dlus_name="";
$arg_local_node_id="";
$arg_adj_node_id="";
$arg_conventional_lu_compression="NO";
$arg_lsap_address="04";
$arg_mac_address="";
$arg_ls_attributes="SNA";
$arg_cp_cp_sess_support="YES";
$arg_hpr_supported="YES";
$arg_hpr_link_lvl_error="NO";
$arg_tg_number="0";
$arg_solicit_sscp_sessions="NO";
$arg_max_send_btu_size="1033";
$arg_default_nn_server="NO";
$arg_ls_role="USE_PORT_DEFAULTS";
$arg_branch_link_type="NONE";
$arg_xid_timer_retry="5";
$arg_restart_on_normal_deact="NO";
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port -d`;
foreach $line (@contents) {
     next if ($line=~m/-----/);   # Do not display seperaters
        
     if ($line=~m/port_name/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         $port_name= $data[1];
         next;
     }elsif ($line=~m/dlc_type/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
         if ($data[1]=~m/ETHERNET/) {
              push @portlist, $port_name;
         }
         next;
     }
}
    
$len=@portlist;
if($len eq 0){
    print "<br> Ethernet Port should be defined before define Ethernet Link Station. ";
    exit 1;
}
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}

  
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addetherls.cgi\" method=\"post\">\n";   

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #  Link station name
print "<tr><td>* Link station name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ethlsname_unique\"  maxlength=\"8\" value=\"$arg_eth_ls_name\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.#@\$]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\" maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #  Initially active?
print "<tr><td>Initially active ?</td> <td> <select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" >";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Port name
print "<tr><td>* Port Name :</td> <td><select name=\"port_name\"  class=\"rightAligned\" value=\"$arg_port_name\" >  ";
foreach $line (@portlist) {
   print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
print "<tr><td>Independent LU Traffic : ";
    
    # Remote node Control Point name
print "<tr><td>Remote node Control Point name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"adj_cp_name\"  maxlength=\"17\" value=\"$arg_adj_cp_name\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #  Remote node type
print "<tr><td>Remote node type : </td> <td><select name=\"adj_cp_type\"  class=\"rightAligned\" value=\"$arg_adj_cp_type\">  ";
print "<option value=\"LEARN_NODE\" selected=\"selected\">LEARN_NODE</option> ";
print "<option value=\"END_NODE\">END_NODE</option>";
print "<option value=\"NETWORK_NODE\">NETWORK_NODE</option> ";
print "<option value=\"BACK_LEVEL_LEN_NODE\">BACK_LEVEL_LEN_NODE</option>";
print "<option value=\"HOST_XID3\">HOST_XID3</option> ";
print "<option value=\"HOST_XID0\">HOST_XID0</option>";
print "<option value=\"DSPU_XID\">DSPU_XID</option> ";
print "<option value=\"DSPU_NOXID\">DSPU_NOXID</option> </select></td></tr>";
    
print "<tr><td>Dependent LU Traffic : </td></tr>";
    
    # Downsteam PU services supplied
print "<tr><td>Downsteam PU services supplied : </td> <td><select name=\"dspu_services\"  class=\"rightAligned\" value=\"$arg_dspu_services\" >  ";
print "<option value=\"PU_CONCENTRATION\">PU_CONCENTRATION</option> ";
print "<option value=\"DLUR\">DLUR</option>";
print "<option value=\"NONE\" selected=\"selected\">NONE</option> </select></td></tr>";
    
print "<tr><td>If SNA Gateway or DLUR ,</td></tr> ";
    # Downstream PU name
print "<tr><td>Downstream PU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dspu_name\"  maxlength=\"8\" value=\"$arg_dspu_name\" /oninput=\"value=value.replace(/[^A-Z0-9#@\$]/g,'')\" /></td></tr>";
    
print "<tr><td>If DLUR ,</td></tr> ";
    # DLUS server name
print "<tr><td>DLUS server name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"dlus_name\"  maxlength=\"17\" value=\"$arg_dlus_name\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    # Local node id
print "<tr><td>Local node id(Hex.) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"local_node_id\"  maxlength=\"8\" value=\"$arg_local_node_id\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";

    #  Remote node id
print "<tr><td>Remote node id(Hex.) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"adj_node_id\"  maxlength=\"8\" value=\"$arg_adj_node_id\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";

    #  Compression Supported ?
print "<tr><td>Compression Supported : </td> <td><select name=\"conventional_lu_compression\"  class=\"rightAligned\" value=\"$arg_conventional_lu_compression\" > ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
print "<tr><td>Contact Information :  </td></tr>";
    #  Remote node MAC address
print "<tr><td>Remote node MAC address(Hex.) :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"mac_address\"  maxlength=\"12\" value=\"$arg_mac_address\" oninput=\"value=value.replace(/[^0-9a-fA-F:]/g,'')\" /></td></tr>";
    
    #   Remote node SAP address
print "<tr><td>Remote node SAP address(Hex.) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"lsap_address\"  maxlength=\"2\" value=\"$arg_lsap_address\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";
    
print "<tr><td>Advanced : </td></tr> ";
    #   Maximum BTU size allowed
print "<tr><td>Maximum BTU size to be sent(265-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_send_btu_size\"  maxlength=\"5\" value=\"$arg_max_send_btu_size\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    # Host Type
print "<tr><td>Host Type :</td> <td><select name=\"ls_attributes\"  class=\"rightAligned\" value=\"$arg_ls_attributes\" >  ";
print "<option value=\"SNA\" selected=\"selected\">SNA</option> ";
print "<option value=\"FNA\">FNA</option>";
print "<option value=\"HNA\">HNA</option>";
print "<option value=\"SUPPRESS_CP_NAME\" >SUPPRESS_CP_NAME</option> </select></td></tr>";
    
    #  Request CP-CP sessions?
print "<tr><td>Request CP-CP sessions ? </td> <td><select name=\"cp_cp_sess_support\"  class=\"rightAligned\" value=\"$arg_cp_cp_sess_support\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Use HPR?
print "<tr><td>Use HPR ? </td> <td><select name=\"hpr_supported\"  class=\"rightAligned\" value=\"$arg_hpr_supported\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Use HPR link level error recovery?
print "<tr><td>Use HPR link level error recovery ? </td> <td><select name=\"hpr_link_lvl_error\"  class=\"rightAligned\" value=\"$arg_hpr_link_lvl_error\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #  TG number
print "<tr><td>TG number(0-20) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tg_number\"  maxlength=\"2\" value=\"$arg_tg_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Solicit SSCP sessions?
print "<tr><td>Solicit SSCP sessions ? </td> <td><select name=\"solicit_sscp_sessions\"  class=\"rightAligned\" value=\"$arg_solicit_sscp_sessions\" > ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Remote node is a network node server?
print "<tr><td>Remote node is a network node server ?</td> <td><select name=\"default_nn_server\"  class=\"rightAligned\" value=\"$arg_default_nn_server\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #  Link station role
print "<tr><td>Link station role : </td> <td><select name=\"ls_role\"  class=\"rightAligned\" value=\"$arg_ls_role\" >  ";
print "<option value=\"LS_PRI\">LS_PRI</option> ";
print "<option value=\"LS_SEC\">LS_SEC</option> ";
print "<option value=\"LS_NEG\">LS_NEG</option> ";
print "<option value=\"USE_PORT_DEFAULTS\" selected=\"selected\">USE_PORT_DEFAULTS</option> </select></td></tr>";

    #   Branch link type
print "<tr><td>Branch link type : </td> <td><select name=\"branch_link_type\"  class=\"rightAligned\" value=\"$arg_branch_link_type\" >  ";
print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
print "<option value=\"DOWNLINK\">DOWNLINK</option> ";
print "<option value=\"UPLINK\" >UPLINK</option> </select></td></tr>";
    
    #   Restart on normal deactivation
print "<tr><td>Restart on normal deactivation : </td> <td> <select name=\"restart_on_normal_deact\"  class=\"rightAligned\" value=\"$arg_restart_on_normal_deact\" >  ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

    #  XID retry count
print "<tr><td>XID timer retry count(0-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"xid_timer_retry\"  maxlength=\"3\" value=\"$arg_xid_timer_retry\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

