#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_ethdlcname,$arg_ethdevname,$arg_description, $arg_neg_ls_supp, 
    $arg_initially_active, $arg_adapter_number, $arg_lan_type,$devicename, 
    $description, $adapter_number, $remote_addr, $remote_port, $time, $line,
    @data, @contents, @retval);

$arg_ethdlcname="";
$arg_adapter_number="0";
$arg_ethdevname="";
$arg_description="";
$arg_neg_ls_supp="YES";
$arg_initially_active="YES";
$arg_lan_type="802_3_DIX";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}

  
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addetherdlc.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Define DLC name
print "<tr> <td>* DLC name :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"ethdlcname_unique\"  maxlength=\"8\" value=\"$arg_ethdlcname\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_.\$]/g,'')\" /> </td></tr>";
    
    #   Define device name
print "<tr> <td> Device name :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"ethdevname_unique\"  maxlength=\"31\" value=\"$arg_ethdevname\" oninput=\"value=value.replace(/[^a-zA-Z0-9_-.\$]/g,'')\" /> </td></tr>";

    #   Define Description field
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #   Define Negotiable link stations supported?
print "<tr> <td>Negotiable link stations supported ? </td> <td><select name=\"neg_ls_supp\"  class=\"rightAligned\" value=\"$arg_neg_ls_supp\">";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";

    #   Define Initially active?
print "<tr> <td>Initially active ? </td> <td><select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Adapter Number
print "<tr> <td>Adapter Number :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"adapter_number\"  maxlength=\"9\"  value=\"$arg_adapter_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Ethernet type
print "<tr> <td>Ethernet type :</td> <td><select name=\"lan_type\"  class=\"rightAligned\" value=\"$arg_lan_type\" >  ";
print "<option value=\"802_3\">802_3</option> ";
print "<option value=\"DIX\">DIX</option> ";
print "<option value=\"802_3_DIX\" selected=\"selected\">802_3_DIX</option> </select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

