#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_dspu_template, $arg_description, $arg_max_instance, $arg_min_nau, 
    $arg_max_nau, $arg_allow_timeout, $arg_delayed_logon, $arg_host_lu, 
    $description, $max_instance, $time, $remote_addr, $remote_port, $line, 
    @data, @list, @contents, @retval);

$arg_dspu_template="";
$arg_description="";
$arg_max_instance="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
#  Build token for secure invocation of adddspu.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/lu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_pool`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/pool_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/adddspu.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\"> ";
print "<tbody> ";
    
    #   DSPU template name
print "<tr> <td>* DSPU template name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dspu_template_unique\"  maxlength=\"8\" value=\"$arg_dspu_template\" required=\"required\" oninput=\"value=value.replace(/[^a-zA-Z0-9_-.#@\$]/g,'')\" /></td></tr>";
    
    #   Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    #  Maximum number of DSPU instances allowed
print "<tr><td>Maximum number of DSPU instances allowed(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_instance\" maxlength=\"5\" value=\"$arg_max_instance\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";

print "<tr><td><b>if define dslu_template, please fill the requied field below :</b></td></tr>";
    
    # First LU number (1-255)
print "<tr><td>* First LU number (1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"min_nau\" maxlength=\"3\" value=\"$arg_min_nau\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    # Last LU number (1-255)
print "<tr><td>* Last LU number (1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_nau\" maxlength=\"3\" value=\"$arg_max_nau\"  oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    # Allow timeout
print "<tr><td>Allow timeout : </td> <td> <select name=\"allow_timeout\" class=\"rightAligned\" value=\"$arg_allow_timeout\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option></select></td></tr>";
    
    # Allow delayed logon
print "<tr><td>Allow delayed logon : </td> <td> <select name=\"delayed_logon\" class=\"rightAligned\" value=\"$arg_delayed_logon\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option></select></td></tr>";
    
    # Host LU name
print "<tr><td>* Host LU name :</td> <td><select name=\"host_lu\" class=\"rightAligned\" value=\"$arg_host_lu\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@list) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;


