#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_dslu_name, $arg_description, $arg_dspu_name, $arg_nau_address, 
    $arg_host_lu_name, $arg_delayed_logon, $arg_allow_timeout, $description, 
    $remote_addr, $remote_port, $len, $time, $line, @data, @contents, 
    @dspulist, @hostlulist, @retval);

$arg_description="";
$arg_dspu_name="";
$arg_host_lu_name="";
$arg_delayed_logon="NO";
$arg_nau_address="1";
$arg_allow_timeout="NO";
$arg_dslu_name="";

#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
#  Build token for secure invocation of adddslu.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_downstream_pu`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/dspu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @dspulist, $data[1];
        next;
    }
}
    
$len=@dspulist;
if($len eq 0){
    print "<br> Downstream PU should be defined before define Downstream LU. ";
    exit 1;
}
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
       
    if ($line=~m/lu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @hostlulist, $data[1];
        next;
    }
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_pool`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
     
    if ($line=~m/pool_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @hostlulist, $data[1];
        next;
    }
}
$len=@hostlulist;
 if($len eq 0){
    print "<br> HOST LU or Pool name should be defined before define Downstream LU. ";
    exit 1;
}

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_dslu.cgi\" method=\"post\">\n";    
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  LU name
print "<tr><td>* LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dslu_name_unique\" maxlength=\"8\" value=\"$arg_dslu_name\" required=\"required\" oninput=\"value=value.replace(/[^A-Z0-9#@]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
    # * Downstream PU name
print "<tr><td>* Downstream PU name :</td> <td><select name=\"dspu_name\" class=\"rightAligned\" value=\"$arg_dspu_name\" >  ";
foreach $line (@dspulist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #  * LU number
print "<tr><td>* LU number(1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"nau_address\" maxlength=\"3\" value=\"$arg_nau_address\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\"/></td></tr>";
    
    #   * Host LU or Pool name
print "<tr><td>* Host LU or Pool name :</td> <td><select name=\"host_lu_name\" class=\"rightAligned\" value=\"$arg_host_lu_name\" >  ";
foreach $line (@hostlulist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #   Inactivity timeout allowed?
print "<tr><td> Inactivity timeout allowed ? </td> <td> <select name=\"allow_timeout\" class=\"rightAligned\" value=\"$arg_allow_timeout\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option></select></td></tr>";
    
    #   Use delayed logon?
print "<tr><td> Use delayed logon ? </td> <td> <select name=\"delayed_logon\" class=\"rightAligned\" value=\"$arg_delayed_logon\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option></select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

