#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_resource_name, $arg_description, $arg_resource_type, 
    $arg_parent_name, $arg_parent_type, $remote_addr, $remote_port, 
    $time, $line, @contents, @retval);

$arg_description="";
$arg_parent_name="";
$arg_resource_type="LU_RESOURCE";
$arg_parent_type="ENCP_RESOURCE";
$arg_resource_name="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_dir.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  * Resource name
print "<tr><td>* Resource name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"resource_name_unique\" maxlength=\"17\" value=\"$arg_resource_name\" required=\"required\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #  Resource type
print "<tr><td>Resource type : </td> <td><select name=\"resource_type\" class=\"rightAligned\" value=\"$arg_resource_type\" >  ";
print "<option value=\"LU_RESOURCE\" selected=\"selected\">LU_RESOURCE</option> ";
print "<option value=\"ENCP_RESOURCE\">ENCP_RESOURCE</option>";
print "<option value=\"NNCP_RESOURCE\">NNCP_RESOURCE</option>";
print "<option value=\"WILDCARD_LU_RESOURCE\">WILDCARD_LU_RESOURCE</option></select></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" ></td></tr>";
    
    #   Parent name
print "<tr><td>Parent name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"parent_name\" maxlength=\"17\" value=\"$arg_parent_name\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #   Parent type
print "<tr><td>Parent type : </td> <td><select name=\"parent_type\" class=\"rightAligned\" value=\"$arg_parent_type\" >  ";
print "<option value=\"ENCP_RESOURCE\" selected=\"selected\">ENCP_RESOURCE</option> ";
print "<option value=\"NNCP_RESOURCE\">NNCP_RESOURCE</option></select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

