#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_fqcn_name, $arg_description, $arg_port_name, $remote_addr, 
    $remote_port, $port_name, $line, @data, @contents, 
    @portlist, @retval);
#
$arg_fqcn_name="";
$arg_description="";
$arg_port_name="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port -d`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
      
    if ($line=~m/port_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        $port_name= $data[1];
        next;
    }elsif ($line=~m/dlc_type/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        if ($data[1]=~m/HPRIP/) {
            push @portlist, $port_name;
        }elsif($data[1]=~m/ETHERNET/){
            push @portlist, $port_name;
        }
        next;
    }
}
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addcn.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Fully-qualified Connection Network name
print "<tr> <td>* Fully-qualified Connection Network name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fqcn_name_unique\"  maxlength=\"17\" value=\"$arg_fqcn_name\" required=\"required\" /oninput=\"value=value.replace(/[^A-Z0-9.]/g,'')\" /></td></tr>";
    
    #   Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#.:@\$ ]/g,'')\" /></td></tr>";
    
    #   Port name
print "<tr><td>Port Name :</td> <td><select name=\"port_name\"  class=\"rightAligned\" value=\"$arg_port_name\" >  ";
print "<option value=\"\"></option> ";

foreach $line (@portlist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;
 

