#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_tp_name, $arg_lualias, $arg_userid, $arg_description, $arg_group, 
    $arg_type, $arg_env, $arg_path, $arg_arguments, $arg_stdin,  $arg_stdout, 
    $arg_stderr, $description, $lualias, $group, $userid, $path,  $arguments, 
    $stdin, $stdout, $stderr, $env, $time, $token, $hash, $hash_parm, 
    $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Add TP Load Info: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add TP Load Information!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
   $arg_tp_name=param('tp_name_loadinfo_unique');
   $arg_description=param('description');
   $arg_lualias=param('lualias');
   $arg_userid=param('userid');
   $arg_group=param('group');
   $arg_type=param('type');
   $arg_path=param('path');
   $arg_arguments=param('arguments');
   $arg_stdin=param('stdin');
   $arg_stdout=param('stdout');
   $arg_stderr=param('stderr');
   $arg_env=param('env');

    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_lualias eq "") {
        $lualias="";
    }else  {
        $lualias=",lualias=$arg_lualias";
    }
    
    if ($arg_userid eq "") {
        $userid="";
    }else  {
        $userid=",userid=$arg_userid";
    }
    
    if ($arg_group eq "") {
        $group="";
    }else  {
        $group=",group=$arg_group";
    }
    
    if ($arg_arguments eq "") {
        $arguments="";
    }else  {
        $arguments=",arguments=$arg_arguments";
    }

    if ($arg_path eq "") {
        $path="";
    }else  {
        $path=",path=$arg_path";
    }
    
    if ($arg_stdout eq "") {
        $stdout="";
    }else  {
        $stdout=",stdout=$arg_stdout";
    }
    
    if ($arg_stdin eq "") {
        $stdin="";
    }else
    {
        $stdin=",stdin=$arg_stdin";
    }
    
    if ($arg_stderr eq "") {
        $stderr="";
    }else  {
        $stderr=",stderr=$arg_stderr";
    }
    
    if ($arg_env eq "") {
        $env="";
    }else  {
        $env=",env=$arg_env";
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tp_load_info,tp_name=$arg_tp_name, type=$arg_type $description $lualias $group $userid $path $arguments $stdin $stdout $stderr $env`;
    
    print "/opt/ibm/sna/bin/snaadmin define_tp_load_info,tp_name=$arg_tp_name, type=$arg_type $description $lualias $group $userid $path $arguments $stdin $stdout $stderr $env";
   
   print "<br> Display Output from Add LU 6.2 Transaction Program Load Information:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

