#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_force_responses, $arg_keepalive_interval, $arg_keepalive_method, 
    $keepalive_interval, $time, $token, $hash, $hash_parm, $up_time, $line, 
    @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config TN3270 Defaults: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Config TN3270 Defaults!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
   $arg_keepalive_interval=param('keepalive_interval');
   $arg_force_responses=param('force_responses_unique');
   $arg_keepalive_method=param('keepalive_method');
    
    if ($arg_keepalive_interval eq "") {
        $keepalive_interval="";
    }else  {
        $keepalive_interval=",keepalive_interval=$arg_keepalive_interval";
    }
    

    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_defaults, force_responses=$arg_force_responses, keepalive_method=$arg_keepalive_method $keepalive_interval`;
    
    print "/opt/ibm/sna/bin/snaadmin define_tn3270_defaults, force_responses=$arg_force_responses, keepalive_method=$arg_keepalive_method $keepalive_interval";
   
   print "<br> Display Output from Add TN3270 Server Defaults:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

