#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_dcas_server, $arg_dcas_port, $arg_enabled, $dcas_port,
    $time, $remote_addr, $token, $hash, $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Express Logon Feature : $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add Express Logon Feature!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
    $arg_dcas_server=param('dcas_server_unique');
    $arg_dcas_port=param('dcas_port');
    $arg_enabled=param('enabled');
    
    if ($arg_dcas_port eq "") {
        $dcas_port="";
    }else  {
        $dcas_port=",dcas_port=$arg_dcas_port";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_express_logon, dcas_server=$arg_dcas_server, enabled=$arg_enabled $dcas_port`;
    
    print "/opt/ibm/sna/bin/snaadmin define_tn3270_express_logon, dcas_server=$arg_dcas_server, enabled=$arg_enabled $dcas_port";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add TN3270 Express Logon:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

