#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_timeout, $arg_resource_name, $arg_resource_type, $resource_name, 
    $resource_type, $time, $token, $hash, $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Connection Networks Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add Session Timeout!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
   $arg_resource_name=param('resource_name');
   $arg_timeout=param('timeout_unique');
   $arg_resource_type=param('resource_type');
    
    if ($arg_resource_name eq "") {
        $resource_name="";
    }else  {
        $resource_name=",resource_name=$arg_resource_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu62_timeout, timeout=$arg_timeout, resource_type=$arg_resource_type $resource_name`;
    
    print "/opt/ibm/sna/bin/snaadmin define_lu62_timeout, timeout=$arg_timeout, resource_type=$arg_resource_type $resource_name";
   
    print "<br> Display Output from Define LU 6.2 Session Timeout:<br>";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

