#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_fqplu_name, $arg_description, $arg_lu_alias, $arg_password, 
    $description, $lu_alias, $time, $token, $hash, $hash_parm, 
    $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Connection Networks Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add Session Security!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }

   $arg_description=param('description');
   $arg_lu_alias=param('lu_alias');
   $arg_fqplu_name=param('fqplu_name_ss_unique');
   $arg_password=param('password');
  
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    if ($arg_lu_alias eq "") {
        $lu_alias="";
    }else  {
        $lu_alias=",lu_alias=$arg_lu_alias";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_lu_password, fqplu_name=$arg_fqplu_name, password=0x$arg_password $description $lu_alias`;
    
    print "/opt/ibm/sna/bin/snaadmin define_lu_lu_password, fqplu_name=$arg_fqplu_name, password=0x$arg_password $description $lu_alias";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add LU 6.2 Session Security Definition :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</b>";

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

