#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_pu_name, $arg_description, $arg_bkup_dlus_name, $arg_dlus_name, 
    $arg_initially_active, $arg_conventional_lu_compression, 
    $arg_dlus_retry_limit, $arg_pu_id, $description, $dlus_name, 
    $bkup_dlus_name, $pu_id,$dlus_retry_limit, $time, $token, $hash, 
    $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Add DLUR PU Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add DLUR PU!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_add_indep_lu6.2.cgi session
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
   $arg_pu_name=param('pu_name_unique');
   $arg_description=param('description');
   $arg_bkup_dlus_name=param('bkup_dlus_name');
   $arg_dlus_name=param('dlus_name');
   $arg_initially_active=param('initially_active');
   $arg_pu_id=param('pu_id');
   $arg_conventional_lu_compression=param('conventional_lu_compression');
   $arg_dlus_retry_limit=param('dlus_retry_limit');

   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    if ($arg_dlus_name eq "") {
        $dlus_name="";
    }else  {
        $dlus_name=",dlus_name=$arg_dlus_name";
    }
    
    if ($arg_bkup_dlus_name eq "") {
        $bkup_dlus_name="";
    }else  {
        $bkup_dlus_name=",bkup_dlus_name=$arg_bkup_dlus_name";
    }
    
    if ($arg_dlus_retry_limit eq "") {
        $dlus_retry_limit="";
    }else  {
        $dlus_retry_limit=",dlus_retry_limit=$arg_dlus_retry_limit";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_internal_pu, pu_name= $arg_pu_name, initially_active=$arg_initially_active, conventional_lu_compression=$arg_conventional_lu_compression, pu_id=0x$arg_pu_id $bkup_dlus_name $dlus_name $description $dlus_retry_limit`;
    
    print "/opt/ibm/sna/bin/snaadmin define_internal_pu, pu_name= $arg_pu_name, initially_active=$arg_initially_active, conventional_lu_compression=$arg_conventional_lu_compression, pu_id=0x$arg_pu_id $bkup_dlus_name $dlus_name $description $dlus_retry_limit";
   
   print "<br> Display Output from Add DLUR PU:<br>";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

