#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_base_name, $arg_description, $arg_pu_name,$arg_min_nau, 
    $arg_max_nau, $arg_pool_name, $arg_lu_model, $arg_sscp_id, $arg_timeout, 
    $arg_name_attributes, $arg_base_number, $description, $pool_name, $type, 
    $timeout, $sscp_id, $base_number, $len, $time, $token, $hash, $hash_parm, 
    $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Add Dependent LU 0-3 Range Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add Dependent LU 0-3 Range!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_add_indep_lu6.2.cgi session
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
   $arg_base_name=param('lu0-3_base_name_unique');
   $arg_description=param('description');
   $arg_pu_name=param('pu_name');
   $arg_pool_name=param('pool_name');
   $arg_lu_model=param('lu_model');
   $arg_sscp_id=param('sscp_id');
   $arg_timeout=param('timeout');
   $arg_min_nau=param('min_nau');
   $arg_max_nau=param('max_nau');
   $arg_base_number=param('base_number');
   $arg_name_attributes=param('name_attributes');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_timeout eq "") {
        $timeout="";
    }else  {
        $timeout=",timeout=$arg_timeout";
    }

    if ($arg_sscp_id eq "") {
        $sscp_id="";
    }else  {
        $sscp_id=",sscp_id=$arg_sscp_id";
    }

    if ($arg_pool_name eq "") {
        $pool_name="";
    }else  {
        $pool_name=",pool_name=$arg_pool_name";
    }
    
    if ($arg_base_number eq "") {
        $base_number="";
    }else  {
        $base_number=",base_number=$arg_base_number";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_0_to_3_range,base_name=$arg_base_name, min_nau=$arg_min_nau, max_nau=$arg_max_nau, pu_name=$arg_pu_name, lu_model=$arg_lu_model, name_attributes=$arg_name_attributes $sscp_id $pool_name $description $timeout $base_number`;
    
    print "/opt/ibm/sna/bin/snaadmin define_lu_0_to_3_range,base_name=$arg_base_name, min_nau=$arg_min_nau, max_nau=$arg_max_nau, pu_name=$arg_pu_name, lu_model=$arg_lu_model, name_attributes=$arg_name_attributes $sscp_id $pool_name $description $timeout $base_number";
   
   print "Display Output from Add Range Of LUs Type 0-3:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

