#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_ms_category, $arg_description, $arg_fp_fqcp_name, 
    $arg_ms_appl_name, $description, $ms_appl_name, $fp_fqcp_name, 
    $time, $token, $hash, $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Focal Point Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Focal Point management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }

   $arg_description=param('description');
   $arg_ms_category=param('ms_category_unique');
   $arg_fp_fqcp_name=param('fp_fqcp_name');
   $arg_ms_appl_name=param('ms_appl_name');
    
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_fp_fqcp_name eq "") {
        $fp_fqcp_name="";
    }else  {
        $fp_fqcp_name=",fp_fqcp_name=$arg_fp_fqcp_name";
    }
    
    if ($arg_ms_appl_name eq "") {
        $ms_appl_name="";
    }else  {
        $ms_appl_name=",ms_appl_name=$arg_ms_appl_name";
    }
    
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_focal_point, ms_category=$arg_ms_category  $fp_fqcp_name $description $ms_appl_name 1>&2`;
    
   
   print "<br> Display Output from Add Focal Point:";
    
   foreach $line (@contents) {
   #      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

