#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_eth_port_name, $arg_description, $arg_port_number,$arg_dlc_name, 
    $arg_initially_active, $arg_lsap_address, $arg_implicit_hpr_support, 
    $arg_implicit_link_lvl_error, $arg_implicit_uplink_to_en, $arg_max_rcv_btu_size, 
    $arg_tot_link_act_lim,$arg_implicit_dspu_template, $arg_max_ifrm_rcvd, 
    $arg_xid_timer_retry, $description, $dlc_name, $len,$port_number, $lsap_address,
    $max_rcv_btu_size, $tot_link_act_lim,$implicit_dspu_template, $max_ifrm_rcvd, 
    $xid_timer_retry, $token, $hash, $hash_parm, $up_time, $time, $line, @data, 
    @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Port Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Port management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }

   $arg_eth_port_name=param('ethportname_unique');   # get ethernet port name
   $arg_description=param('description');  # get Description
   $arg_port_number=param('port_number');  # get port number
   $arg_dlc_name=param('dlc_name');
   $arg_initially_active=param('initially_active');
   $arg_lsap_address=param('lsap_address');
   $arg_implicit_hpr_support=param('implicit_hpr_support');
   $arg_implicit_link_lvl_error=param('implicit_link_lvl_error');
   $arg_implicit_uplink_to_en=param('implicit_uplink_to_en');
   $arg_max_rcv_btu_size=param('max_rcv_btu_size');
   $arg_tot_link_act_lim=param('tot_link_act_lim');
   $arg_implicit_dspu_template=param('implicit_dspu_template');
   $arg_max_ifrm_rcvd=param('max_ifrm_rcvd');
   $arg_xid_timer_retry=param('xid_timer_retry');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else {
        $description=",description=$arg_description";
    }
    if ($arg_port_number eq "") {
        $port_number="";
    }else {
        $port_number=",port_number=$arg_port_number";
    }
    
    if ($arg_lsap_address eq "") {
        $lsap_address="";
    }else {
        $lsap_address=",lsap_address=0x$arg_lsap_address";
    }
    
    if ($arg_max_rcv_btu_size eq "") {
        $max_rcv_btu_size="";
    }else {
        $max_rcv_btu_size=",max_rcv_btu_size=$arg_max_rcv_btu_size";
    }
    
    if ($arg_tot_link_act_lim eq "") {
        $tot_link_act_lim="";
    }else {
        $tot_link_act_lim=",tot_link_act_lim=$arg_tot_link_act_lim";
    }
    
    if ($arg_implicit_dspu_template eq "") {
        $implicit_dspu_template="";
    }else {
        $implicit_dspu_template=",implicit_dspu_template=$arg_implicit_dspu_template";
    }
    
    if ($arg_max_ifrm_rcvd eq "") {
        $max_ifrm_rcvd="";
    }else {
        $max_ifrm_rcvd=",max_ifrm_rcvd=$arg_max_ifrm_rcvd";
    }
    
    if ($arg_xid_timer_retry eq "") {
        $xid_timer_retry="";
    }else {
        $xid_timer_retry=",xid_timer_retry=$arg_xid_timer_retry";
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_port,port_name= $arg_eth_port_name, dlc_name=$arg_dlc_name  , initially_active=$arg_initially_active  , implicit_hpr_support=$arg_implicit_hpr_support  , implicit_link_lvl_error=$arg_implicit_link_lvl_error  , implicit_uplink_to_en=$arg_implicit_uplink_to_en  $port_number $lsap_address  $max_rcv_btu_size $tot_link_act_lim $implicit_dspu_template $max_ifrm_rcvd  $xid_timer_retry  $description `;
    
    print "/opt/ibm/sna/bin/snaadmin define_ethernet_port,port_name= $arg_eth_port_name, dlc_name=$arg_dlc_name  , initially_active=$arg_initially_active  , implicit_hpr_support=$arg_implicit_hpr_support  , implicit_link_lvl_error=$arg_implicit_link_lvl_error  , implicit_uplink_to_en=$arg_implicit_uplink_to_en  $port_number $lsap_address  $max_rcv_btu_size $tot_link_act_lim $implicit_dspu_template $max_ifrm_rcvd  $xid_timer_retry  $description ";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Ethernet Port:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

