#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_eth_ls_name, $arg_description, $arg_initially_active,
    $arg_port_name, $arg_adj_cp_name, $arg_adj_cp_type,$arg_dspu_services, 
    $arg_dspu_name, $arg_dlus_name, $arg_local_node_id,$arg_adj_node_id,
    $arg_conventional_lu_compression,$arg_mac_address,$arg_lsap_address, 
    $arg_ls_attributes,$arg_cp_cp_sess_support,$arg_hpr_supported, 
    $arg_hpr_link_lvl_error, $arg_tg_number,$arg_solicit_sscp_sessions, 
    $arg_max_send_btu_size, $arg_default_nn_server,$arg_ls_role, 
    $arg_branch_link_type, $arg_xid_timer_retry,$arg_restart_on_normal_deact, 
    $description, $port_name, $len,$tg_number, $lsap_address,$max_send_btu_size, 
    $adj_cp_name,$dspu_name, $dlus_name,$local_node_id,$adj_node_id,$mac_address, 
    $xid_timer_retry, $time, $token, $hash, $hash_parm, $up_time, $line,
    @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Link Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of LS management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }

    $arg_eth_ls_name=param('ethlsname_unique');
    $arg_description=param('description');
    $arg_port_name=param('port_name');
    $arg_initially_active=param('initially_active');
    $arg_adj_cp_name=param('adj_cp_name');
    $arg_adj_cp_type=param('adj_cp_type');
    $arg_dspu_services=param('dspu_services');
    $arg_dspu_name=param('dspu_name');
    $arg_dlus_name=param('dlus_name');
    $arg_local_node_id=param('local_node_id');
    $arg_adj_node_id=param('adj_node_id');
    $arg_conventional_lu_compression=param("conventional_lu_compression");
    $arg_lsap_address=param('lsap_address');
    $arg_mac_address=param('mac_address');
    $arg_ls_attributes=param('ls_attributes');
    $arg_cp_cp_sess_support=param('cp_cp_sess_support');
    $arg_hpr_supported=param('hpr_supported');
    $arg_hpr_link_lvl_error=param('hpr_link_lvl_error');
    $arg_tg_number=param('tg_number');
    $arg_solicit_sscp_sessions=param('solicit_sscp_sessions');
    $arg_max_send_btu_size=param('max_send_btu_size');
    $arg_default_nn_server=param('default_nn_server');
    $arg_ls_role=param('ls_role');
    $arg_branch_link_type=param('branch_link_type');
    $arg_xid_timer_retry=param('xid_timer_retry');
    $arg_restart_on_normal_deact=param('restart_on_normal_deact');
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_adj_cp_name eq "") {
        $adj_cp_name="";
    }else  {
        $adj_cp_name=",adj_cp_name=$arg_adj_cp_name";
    }
    
    if ($arg_dspu_name eq "") {
        $dspu_name="";
    }else  {
        $dspu_name=",dspu_name=$arg_dspu_name";
    }
    
    if ($arg_dlus_name eq "") {
        $dlus_name="";
    }else  {
        $dlus_name=",dlus_name=$arg_dlus_name";
    }
    
    if ($arg_local_node_id eq "") {
        $local_node_id="";
    }else  {
        $local_node_id=",local_node_id=0x$arg_local_node_id";
    }
    
    if ($arg_adj_node_id eq "") {
        $adj_node_id="";
    }else  {
        $adj_node_id=",adj_node_id=0x$arg_adj_node_id";
    }
    
    if ($arg_mac_address eq "") {
        $mac_address="";
    }else  {
        $mac_address=",mac_address=0x$arg_mac_address";
    }
    
    if ($arg_tg_number eq "") {
        $tg_number="";
    }else  {
        $tg_number=",tg_number=$arg_tg_number";
    }
    
    if ($arg_lsap_address eq "") {
        $lsap_address="";
    }else  {
        $lsap_address=",lsap_address=0x$arg_lsap_address";
    }
    
    if ($arg_max_send_btu_size eq "") {
        $max_send_btu_size="";
    }else  {
        $max_send_btu_size=",max_send_btu_size=$arg_max_send_btu_size";
    }
    
    if ($arg_xid_timer_retry eq "") {
        $xid_timer_retry="";
    }else {
        $xid_timer_retry=",xid_timer_retry=$arg_xid_timer_retry";
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_ls,ls_name=$arg_eth_ls_name,port_name=$arg_port_name  , initially_active=$arg_initially_active  , adj_cp_type=$arg_adj_cp_type , dspu_services=$arg_dspu_services ,conventional_lu_compression=$arg_conventional_lu_compression , ls_attributes=$arg_ls_attributes , cp_cp_sess_support=$arg_cp_cp_sess_support , hpr_supported=$arg_hpr_supported  , hpr_link_lvl_error=$arg_hpr_link_lvl_error  , solicit_sscp_sessions=$arg_solicit_sscp_sessions , default_nn_server=$arg_default_nn_server , ls_role=$arg_ls_role , branch_link_type=$arg_branch_link_type , restart_on_normal_deact=$arg_restart_on_normal_deact $tg_number $lsap_address  $max_send_btu_size  $xid_timer_retry  $description $adj_cp_name $dspu_name $dlus_name $local_node_id $adj_node_id $mac_address`;
    
    print "/opt/ibm/sna/bin/snaadmin define_ethernet_ls,ls_name=$arg_eth_ls_name,port_name=$arg_port_name  , initially_active=$arg_initially_active  , adj_cp_type=$arg_adj_cp_type , dspu_services=$arg_dspu_services ,conventional_lu_compression=$arg_conventional_lu_compression , ls_attributes=$arg_ls_attributes , cp_cp_sess_support=$arg_cp_cp_sess_support , hpr_supported=$arg_hpr_supported  , hpr_link_lvl_error=$arg_hpr_link_lvl_error  , solicit_sscp_sessions=$arg_solicit_sscp_sessions , default_nn_server=$arg_default_nn_server , ls_role=$arg_ls_role , branch_link_type=$arg_branch_link_type , restart_on_normal_deact=$arg_restart_on_normal_deact $tg_number $lsap_address  $max_send_btu_size  $xid_timer_retry  $description $adj_cp_name $dspu_name $dlus_name $local_node_id $adj_node_id $mac_address ";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Ethernet Link Station :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

