#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#Fix issue with underscore in LS name                       #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_ethdlcname,$arg_ethdevname,$arg_description, $arg_neg_ls_supp, 
    $arg_initially_active, $arg_adapter_number, $arg_lan_type,$devicename, 
    $description, $adapter_number, $token, $hash, $hash_parm, $up_time, $time, 
    $line, @data, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage DLC Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of DLC management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
     $arg_ethdlcname=param('ethdlcname_unique');   # get ethernet dlc name
     $arg_ethdevname=param('ethdevname_unique');   # get ethernet device name
     $arg_description=param('description');  # get Description
     $arg_neg_ls_supp=param('neg_ls_supp');   # get Negotiable link stations supported?
     $arg_initially_active=param('initially_active');       #get initially active?
     $arg_adapter_number=param('adapter_number');       #get Adapter Number
     $arg_lan_type=param('lan_type');       #get Ethernet type
    
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_ethdevname eq "") {
        $devicename="";
    }else {
        $devicename=",device_name=$arg_ethdevname";
    }

    if ($arg_description eq "") {
        $description="";
    }else {
        $description=",description=$arg_description";
    }
    
    if ($arg_adapter_number eq "") {
        $adapter_number="";
    }else {
        $adapter_number=",adapter_number=$arg_adapter_number";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ethernet_dlc,dlc_name=$arg_ethdlcname $devicename, neg_ls_supp=$arg_neg_ls_supp, initially_active=$arg_initially_active, lan_type=$arg_lan_type $adapter_number $description `;
    
    print "/opt/ibm/sna/bin/snaadmin define_ethernet_dlc,dlc_name=$arg_ethdlcname $devicename, neg_ls_supp=$arg_neg_ls_supp, initially_active=$arg_initially_active, lan_type=$arg_lan_type $adapter_number $description";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Ethernet DLC:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

