#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $action, $lsname, $time, @result, $token, $hash, $hash_parm, 
	$up_time, $line, @contents);
my ($arg, $arg_ee_ls_name, $arg_description, $arg_initially_active,
    $arg_port_name, $arg_adj_cp_name, $arg_adj_cp_type, $arg_remote_ip_host,
    $arg_max_retry,$arg_liveness_timeout, $arg_cp_cp_sess_support,$arg_ip_version, 
    $arg_tg_number, $arg_max_send_btu_size, $arg_default_nn_server,
    $arg_branch_link_type, $arg_ack_timeout,$arg_restart_on_normal_deact, 
    $description, $port_name, $len,$tg_number, $liveness_timeout,
    $max_send_btu_size, $adj_cp_name,$max_retry, $ack_timeout, $time, 
    $token, $hash, $hash_parm, $up_time, $line, @data, @contents, @portlist);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Link Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of LS management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }

    $arg_ee_ls_name=param('eelsname_unique');
    $arg_description=param('description');
    $arg_port_name=param('port_name');
    $arg_initially_active=param('initially_active');
    $arg_adj_cp_name=param('adj_cp_name');
    $arg_adj_cp_type=param('adj_cp_type');
    $arg_remote_ip_host=param('remote_ip_host');
    $arg_max_send_btu_size=param('max_send_btu_size');
    $arg_cp_cp_sess_support=param('cp_cp_sess_support');
    $arg_default_nn_server=param('default_nn_server');
    $arg_ip_version=param('ip_version');
    $arg_tg_number=param('tg_number');
    $arg_branch_link_type=param('branch_link_type');
    $arg_restart_on_normal_deact=param('restart_on_normal_deact');
    $arg_ack_timeout=param('ack_timeout');
    $arg_liveness_timeout=param('liveness_timeout');
    $arg_max_retry=param('max_retry');
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_adj_cp_name eq "") {
        $adj_cp_name="";
    }else
    {
        $adj_cp_name=",adj_cp_name=$arg_adj_cp_name";
    }
    
    if ($arg_max_retry eq "") {
        $max_retry="";
    }else
    {
        $max_retry=",max_retry=$arg_max_retry";
    }
    
    if ($arg_tg_number eq "") {
        $tg_number="";
    }else
    {
        $tg_number=",tg_number=$arg_tg_number";
    }
    
    if ($arg_liveness_timeout eq "") {
        $liveness_timeout="";
    }else
    {
        $liveness_timeout=",liveness_timeout=$arg_liveness_timeout";
    }
    
    if ($arg_max_send_btu_size eq "") {
        $max_send_btu_size="";
    }else
    {
        $max_send_btu_size=",max_send_btu_size=$arg_max_send_btu_size";
    }
    
    if ($arg_ack_timeout eq "") {
        $ack_timeout="";
    }else
    {
        $ack_timeout=",ack_timeout=$arg_ack_timeout"
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_ls,ls_name=$arg_ee_ls_name,port_name=$arg_port_name , initially_active=$arg_initially_active , remote_ip_host=$arg_remote_ip_host, adj_cp_type=$arg_adj_cp_type , cp_cp_sess_support=$arg_cp_cp_sess_support , ip_version=$arg_ip_version , default_nn_server=$arg_default_nn_server , branch_link_type=$arg_branch_link_type , restart_on_normal_deact=$arg_restart_on_normal_deact $tg_number $liveness_timeout  $max_send_btu_size  $ack_timeout  $description $adj_cp_name  $max_retry`;
    
    print "/opt/ibm/sna/bin/snaadmin define_ip_ls,ls_name=$arg_ee_ls_name,port_name=$arg_port_name , initially_active=$arg_initially_active , remote_ip_host=$arg_remote_ip_host, adj_cp_type=$arg_adj_cp_type , cp_cp_sess_support=$arg_cp_cp_sess_support , ip_version=$arg_ip_version , default_nn_server=$arg_default_nn_server , branch_link_type=$arg_branch_link_type , restart_on_normal_deact=$arg_restart_on_normal_deact $tg_number $liveness_timeout  $max_send_btu_size  $ack_timeout  $description $adj_cp_name  $max_retry";
   
# Display output of snaadmin query_node
   print " Display Output from Add Enterprise Extender Link Station :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

