#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_dspu_template, $arg_description, $arg_max_instance, $arg_min_nau, 
    $arg_max_nau, $arg_allow_timeout, $arg_delayed_logon, $arg_host_lu, 
    $description, $max_instance, $time, $token, $hash, $hash_parm, $up_time, 
    $line, @data, @list, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage DSPU Template Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of DSPU Template management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time";

     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
     $arg_dspu_template=param('dspu_template_unique');
     $arg_description=param('description');
     $arg_max_instance=param('max_instance');
     $arg_min_nau=param('min_nau');
     $arg_max_nau=param('max_nau');
     $arg_host_lu=param('host_lu');
     $arg_delayed_logon=param('delayed_logon');
     $arg_allow_timeout=param('allow_timeout');

  
    if ($arg_description eq "") {
        $description="";
    }else {
        $description=",description=$arg_description";
    }
    
    if ($arg_max_instance eq "") {
        $max_instance="";
    }else {
        $max_instance=",max_instance=$arg_max_instance";
    }
    
    print "<br> Display Output from Add DSPU Template :";
    
    if ($arg_min_nau eq "" && $arg_max_nau eq "" && $arg_host_lu eq "" )
    {
        @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_dspu_template,  template_name=$arg_dspu_template $description $max_instance`;
        
        print "/opt/ibm/sna/bin/snaadmin define_dspu_template, template_name=$arg_dspu_template $description $max_instance";
    } elsif($arg_min_nau ne "" && $arg_max_nau ne "" && $arg_host_lu ne "" )
    {
        @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_dspu_template,  template_name=$arg_dspu_template $description $max_instance ,{dslu_template}, min_nau=$arg_min_nau, max_nau=$arg_max_nau, host_lu=$arg_host_lu, allow_timeout=$arg_allow_timeout, delayed_logon=$arg_delayed_logon`;
        
        print "/opt/ibm/sna/bin/snaadmin define_dspu_template,  template_name=$arg_dspu_template $description $max_instance ,{dslu_template}, min_nau=$arg_min_nau, max_nau=$arg_max_nau, host_lu=$arg_host_lu, allow_timeout=$arg_allow_timeout, delayed_logon=$arg_delayed_logon";
    } else {
        print "<br>if you want to define dslu_template, please fill all the requied field or left them empty. ";
        @contents="";
    }
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

