#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_lu_alias, $arg_list_name, $arg_lu_name, $arg_description, 
    $arg_pu_name, $arg_nau_address, $arg_default_pool, $arg_syncpt_support, 
    $arg_sscp_id, $arg_timeout, $arg_lu_attributes,  $arg_sys_name, 
    $description, $timeout, $sscp_id, $sys_name, $list_name, $type, $len, 
    $time, $hash, $hash_parm, $up_time, $token, $line, @data, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Add Dependent LU Type 6.2 Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Dependent LU Type 6.2 management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time";
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
   $arg_lu_alias=param('dep_lu_alias_unique');
   $arg_description=param('description');
   $arg_pu_name=param('pu_name');
   $arg_default_pool=param('default_pool');
   $arg_syncpt_support=param('syncpt_support');
   $arg_sscp_id=param('sscp_id');
   $arg_timeout=param('timeout');
   $arg_nau_address=param('nau_address');
   $arg_list_name=param('list_name');
   $arg_lu_name=param('lu_name');
   $arg_lu_attributes=param('lu_attributes');
   $arg_sys_name=param('sys_name');

    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_timeout eq "") {
        $timeout="";
    }else  {
        $timeout=",timeout=$arg_timeout";
    }

    if ($arg_sscp_id eq "") {
        $sscp_id="";
    }else  {
        $sscp_id=",sscp_id=$arg_sscp_id";
    }
    
    if ($arg_list_name eq "") {
        $list_name="";
    }else  {
        $list_name=",list_name=$arg_list_name";
    }
    
    if ($arg_sys_name eq "") {
        $sys_name="";
    }else  {
        $sys_name=",sys_name=$arg_sys_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_local_lu,lu_alias=$arg_lu_alias, nau_address=$arg_nau_address, pu_name=$arg_pu_name, lu_name=$arg_lu_name, default_pool=$arg_default_pool,  syncpt_support=$arg_syncpt_support, lu_attributes=$arg_lu_attributes, lu_session_limit=1 $list_name  $sscp_id  $description $timeout $sys_name`;
    
    print "/opt/ibm/sna/bin/snaadmin define_local_lu,lu_alias=$arg_lu_alias, nau_address=$arg_nau_address, pu_name=$arg_pu_name, lu_name=$arg_lu_name, default_pool=$arg_default_pool,  syncpt_support=$arg_syncpt_support, lu_attributes=$arg_lu_attributes, lu_session_limit=1 $list_name  $sscp_id  $description $timeout $sys_name";
   
   print "<br>Display Output from Add Dependent LU Type 6.2:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#
print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

