#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $time, $token, $hash, $hash_parm, $arg_list_name, 
    $arg_description, $arg_user_name, $description, 
    $user_name, $up_time, @result, $line, @contents, @retval);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Add Security Access List Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add Security Access List!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time";
 
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match
     print "Failed to validate invocation! <br>";
     exit 1;
   }
   $arg_description=param('description');
   $arg_list_name=param('list_name_unique');
   $arg_user_name=param('user_name');
    
   if ($arg_description eq "") {
       $description=",";
   } else {
       $description=",description=\"$arg_description\",";
   }
    
   if ($arg_user_name eq "") {
       $user_name="";
   } else {
       $user_name=",{security_user_data},user_name=$arg_user_name";
   }
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_security_access_list $description list_name=$arg_list_name $user_name`;
    
    print "/opt/ibm/sna/bin/snaadmin define_security_access_list $description list_name=$arg_list_name $user_name";
   
# Display output of snaadmin query_node
   print "<br><br> Display Output from Add LU 6.2 Access List:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#
print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

