#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_sym_dest_name, $arg_lu_alias, $arg_partner_lu_name, 
    $arg_description, $arg_mode_name, $arg_tp_name_type, $arg_tp_name, 
    $arg_conversation_security_type, $arg_security_user_id, 
    $arg_security_password, $description, $security_password, 
    $security_user_id, $tp_name, $lu_alias, $partner_lu_name, $mode_name, 
    $time, $token, $hash, $hash_parm, $up_time, $line, @contents);
print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Connection Networks Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Add CPIC Side Info!";
} else {
#
#  Get Token from parameter up_time and the IP address and HTTP USER AGEBT Info for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_*.cgi HTTP Info
# 	
   $up_time=param('up_time');
   $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; 
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
   $arg_sym_dest_name=param('sym_dest_name_unique');
   $arg_description=param('description');
   $arg_lu_alias=param('lu_alias');
   $arg_partner_lu_name=param('partner_lu_name');
   $arg_mode_name=param('mode_name');
   $arg_tp_name_type=param('tp_name_type');
   $arg_tp_name=param('tp_name');
   $arg_conversation_security_type=param('conversation_security_type');
   $arg_security_user_id=param('security_user_id');
   $arg_security_password=param('security_password');

    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_security_password eq "") {
        $security_password="";
    }else  {
        $security_password=",security_password=$arg_security_password";
    }

    if ($arg_security_user_id eq "") {
        $security_user_id="";
    }else  {
        $security_user_id=",security_user_id=$arg_security_user_id";
    }
    
    if ($arg_lu_alias eq "") {
        $lu_alias="";
    }else  {
        $lu_alias=",lu_alias=$arg_lu_alias";
    }
    
    if ($arg_tp_name eq "") {
        $tp_name="";
    }else  {
        $tp_name=",tp_name=$arg_tp_name";
    }
    
    if ($arg_mode_name eq "") {
        $mode_name="";
    }else  {
        $mode_name=",mode_name=$arg_mode_name";
    }
    
    if ($arg_partner_lu_name eq "") {
        $partner_lu_name="";
    }else  {
        $partner_lu_name=",partner_lu_name=$arg_partner_lu_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_cpic_side_info,sym_dest_name=$arg_sym_dest_name, conversation_security_type=$arg_conversation_security_type, tp_name_type=$arg_tp_name_type $description $mode_name $tp_name $partner_lu_name $lu_alias $security_user_id  $security_password`;
    
    print "/opt/ibm/sna/bin/snaadmin define_cpic_side_info,sym_dest_name=$arg_sym_dest_name, conversation_security_type=$arg_conversation_security_type, tp_name_type=$arg_tp_name_type $description $mode_name $tp_name $partner_lu_name $lu_alias $security_user_id  $security_password";
   
   print "<br>Display Output from Add Side Information:";
    
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        $line=~s/ /&nbsp;/g;
        print "<br>$line";
     }
}
#
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

