#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_mode_name, $arg_description, $arg_max_neg_sess_lim, 
    $arg_plu_mode_session_limit, $arg_min_conwin_src, $arg_min_conloser_src, 
    $arg_auto_act, $arg_receive_pacing_win, $arg_default_ru_size,$arg_cos_name, 
    $arg_max_receive_pacing_win, $arg_max_ru_size_upp, $arg_compression, 
    $arg_max_ru_size_low,$arg_max_compress_level, $arg_max_decompress_level, 
    $description, $max_neg_sess_lim, $min_conwin_src, $min_conloser_src, 
    $cos_name, $max_receive_pacing_win, $receive_pacing_win, $max_ru_size_upp, 
    $plu_mode_session_limit, $auto_act, $max_ru_size_low, $time, $token,
    $hash, $hash_parm, $up_time, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Add LU 6.2 Mode Definition: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add LU Mode!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_add_indep_lu6.2.cgi session
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
    $arg_mode_name=param('mode_name_unique');
    $arg_description=param('description');
    $arg_max_neg_sess_lim=param('max_neg_sess_lim');
    $arg_plu_mode_session_limit=param('plu_mode_session_limit');
    $arg_min_conwin_src=param('min_conwin_src');
    $arg_min_conloser_src=param('min_conloser_src');
    $arg_auto_act=param('auto_act');
    $arg_max_ru_size_upp=param('max_ru_size_upp');
    $arg_max_ru_size_low=param('max_ru_size_low');
    $arg_default_ru_size=param('default_ru_size');
    $arg_cos_name=param('cos_name');
    $arg_max_receive_pacing_win=param('max_receive_pacing_win');
    $arg_receive_pacing_win=param('receive_pacing_win');
    $arg_compression=param('compression');
    $arg_max_compress_level=param('max_compress_level');
    $arg_max_decompress_level=param('max_decompress_level');
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_max_neg_sess_lim eq "") {
        $max_neg_sess_lim="";
    }else  {
        $max_neg_sess_lim=",max_neg_sess_lim=$arg_max_neg_sess_lim";
    }
    
    if ($arg_plu_mode_session_limit eq "") {
        $plu_mode_session_limit="";
    }else  {
        $plu_mode_session_limit=",plu_mode_session_limit=$arg_plu_mode_session_limit";
    }
    
    if ($arg_auto_act eq "") {
        $auto_act="";
    }else  {
        $auto_act=",auto_act=$arg_auto_act";
    }

    if ($arg_min_conwin_src eq "") {
        $min_conwin_src="";
    }else  {
        $min_conwin_src=",min_conwin_src=$arg_min_conwin_src";
    }
    
    if ($arg_min_conloser_src eq "") {
        $min_conloser_src="";
    }else  {
        $min_conloser_src=",min_conloser_src=$arg_min_conloser_src";
    }
    
    if ($arg_max_receive_pacing_win eq "") {
        $max_receive_pacing_win="";
    }else  {
        $max_receive_pacing_win=",max_receive_pacing_win=$arg_max_receive_pacing_win";
    }
    
    if ($arg_receive_pacing_win eq "") {
        $receive_pacing_win="";
    }else  {
        $receive_pacing_win=",receive_pacing_win=$arg_receive_pacing_win";
    }
    
    if ($arg_max_ru_size_upp eq "") {
        $max_ru_size_upp="";
    }else  {
        $max_ru_size_upp=",max_ru_size_upp=$arg_max_ru_size_upp";
    }
    
    if ($arg_max_ru_size_low eq "") {
        $max_ru_size_low="";
    }else  {
        $max_ru_size_low=",max_ru_size_low=$arg_max_ru_size_low";
    }

    if ($arg_cos_name eq "") {
        $cos_name="";
    }else  {
        $cos_name=",cos_name=$arg_cos_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_mode,mode_name=$arg_mode_name, max_decompress_level=$arg_max_decompress_level, default_ru_size=$arg_default_ru_size, compression=$arg_compression, max_compress_level=$arg_max_compress_level $max_receive_pacing_win $receive_pacing_win$ max_ru_size_upp $max_ru_size_low $description $max_neg_sess_lim $plu_mode_session_limit $auto_act $min_conwin_src $min_conloser_src $cos_name`;
    
    print "/opt/ibm/sna/bin/snaadmin define_mode,mode_name=$arg_mode_name, max_decompress_level=$arg_max_decompress_level, default_ru_size=$arg_default_ru_size, compression=$arg_compression, max_compress_level=$arg_max_compress_level $max_receive_pacing_win $receive_pacing_win$ max_ru_size_upp $max_ru_size_low $description $max_neg_sess_lim $plu_mode_session_limit $auto_act $min_conwin_src $min_conloser_src $cos_name";
   
   print " Display Output from Add LU 6.2 Mode:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

