#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_lu_name, $arg_description, $arg_wildcard_fqplu, 
    $arg_fq_partner_lu, $arg_ls_name, $ls_name,$description, 
    $fq_partner_lu, $time, $token, $hash, $hash_parm, $up_time, $line, 
    @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Add Independent LU Type 6.2 Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
   print "Invalid invocation of Add Independent LU6.2!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_add_indep_lu6.2.cgi session
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

      print "Failed to validate invocation! <br>";
      exit 1;
   }
   $arg_lu_name=param('lu_name_unique');
   $arg_wildcard_fqplu=param('wildcard_fqplu');
   $arg_description=param('description');
   $arg_fq_partner_lu=param('fq_partner_lu');
   $arg_ls_name=param('ls_name');
   
    if ($arg_description eq "") {
        $description="";
    }else  {
        $description=",description=$arg_description";
    }
    
    if ($arg_fq_partner_lu eq "") {
        $fq_partner_lu="";
    }else  {
        $fq_partner_lu=",fq_partner_lu=$arg_fq_partner_lu";
    }
    
   
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ls_routing, lu_name=$arg_lu_name, wildcard_fqplu=$arg_wildcard_fqplu, ls_name=$arg_ls_name $fq_partner_lu $description`;
    
    print "Display Output from Add Link Station Routing for Partner LU:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

