#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $arg_resource_name, $arg_description, $arg_resource_type, 
    $arg_parent_name, $arg_parent_type, $description, $parent_name, 
    $time, $token, $hash, $hash_parm, $up_time, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Config Manage Location On Remote Node Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of Location On Remote Node management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time";
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
    $arg_resource_name=param('resource_name_unique');
    $arg_resource_type=param('resource_type');
    $arg_description=param('description');
    $arg_parent_name=param('parent_name');
    $arg_parent_type=param('parent_type');
   
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_parent_name eq "") {
        $parent_name="";
    }else
    {
        $parent_name=",parent_name=$arg_parent_name";
    }
    
   
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_directory_entry, resource_name=$arg_resource_name, resource_type=$arg_resource_type, parent_type=$arg_parent_type $parent_name $description`;

    print "/opt/ibm/sna/bin/snaadmin define_directory_entry, resource_name=$arg_resource_name, resource_type=$arg_resource_type, parent_type=$arg_parent_type $parent_name $description";
    
    print "<br>Display Output from Define Directory Entry LU:";
       
    print "<b>";
    foreach(@contents) {
       chomp;
       next if (/^------/);
       print "<br>$_"; 
    }
}
print "</b>";



print "</font></p>";
print "\n";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
print "\n";
close (SOURCE);

exit 0; 

