#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2006, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $action, $portname, $portstate, $label, $time, $token, $hash, $hash_parm, 
	$up_time, @result, $line, @contents, @retval);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
$action=" ";
$portname=" ";
$portstate=" ";

print "<b> Communication Server Web Admin Manage Ports Results: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of port management!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
     $up_time=param('up_time');
     $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
     $hash_parm=param('hash');  # Get passed in checksum value
     $hash = md5_hex($token);   # Calculate our own 
     if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
     }
     $arg=param('portslist');
     ($action,$portname) = (split(/_PoRtNaMe_/,$arg) )[0,1];
     if ($action=~m/^start/) {
        print "<b> Start of Port: ",$portname," </b> <br>"; 
        @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin start_port,port_name=$portname `
     } elsif ($action=~m/^stop/) {
         print "<b> Stopping Port: ",$portname," </b> <br>";
         @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin stop_port,port_name=$portname `
     } else {
         print " Invalid action on port management!";
         exit 1;
     }
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_;
}
print "</b><br>";
print "<br><b> Port Status: </b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port`; # Command to get Port status

foreach $line (@contents) {
#  Print the port name and state of each port
   if ($line=~m/port_name/) {
      print $line.":  ";
      print "status: ";
   } elsif ($line=~m/port_state/) {
#  Get state that is active or inactive
      ($label, $portstate) = (split(/=/,$line) );
      $portstate=~s/\s+//g;        # Remove blanks
      print $portstate,"<br>\n";
   }
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0;

