#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use Digest::MD5 qw(md5_hex);
use strict;

my ($arg, $trunc_length, $trace_opt, $time, $check_count, $token, $hash, $hash_parm, 
	$up_time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
$trace_opt = " ";
print "<b> Communication Server Web Admin Trace: $time</b>";
print "<font face=\"Times New Roman, Helvetica\">";
print "<p>\n";
$check_count = 0;
if (! param) {
   print "Invalid invocation of Trace activation!";
} else {
#
#  Get Token from parameter up_time and the IP address and port number for this session.
#  Check hash value passed in to verify a match, which must be same as the cfg_remove_focal_point.cgi session
# 	
   $up_time=param('up_time');
   $token ="$ENV{REMOTE_ADDR}_$ENV{HTTP_USER_AGENT}_$up_time"; # must be same as the cfg_remove_focal_point.cgi session
 
   $hash_parm=param('hash');  # Get passed in checksum value
   $hash = md5_hex($token);   # Calculate our own 
   if ($hash ne $hash_parm) { # Check if these match

	print "Failed to validate invocation! <br>";
	exit 1;
   }
   $arg=param('traceopt');
   if ($arg=~/^none/) {
       $trace_opt = "NONE";
   } elsif ($arg=~/^all/) {
       $trace_opt = "ALL";
   } else {
   # Determine selection of trace flags
     if ($arg=param('node')) {
       $trace_opt.="NODE+";
       $check_count++;
     }
     if ($arg=param('appc')) {
       $trace_opt.="APPC+";
       $check_count++;
     }
     if ($arg=param('fm')) {
       $trace_opt.="FM+";
       $check_count++;
     }
     if ($arg=param('lua')) {
       $trace_opt.="LUA+";
       $check_count++;
     }
     if ($arg=param('nof')) {
       $trace_opt.="NOF+";
       $check_count++;
     }
     if ($arg=param('ms')) {
       $trace_opt.="MS+";
       $check_count++;
     }
     if ($arg=param('dlpi')) {
       $trace_opt.="DLPI+";
       $check_count++;
     }
     if ($arg=param('lli')) {
       $trace_opt.="LLI+";
       $check_count++;
     }
     if ($arg=param('ndlc')) {
       $trace_opt.="NDLC+";
       $check_count++;
     }
     if ($arg=param('dgrm')) {
       $trace_opt.="DGRM+";
       $check_count++;
     }
     if ($arg=param('nli')) {
       $trace_opt.="NLI+";
       $check_count++;
     }
     if ($arg=param('mac')) {
       $trace_opt.="MAC+";
       $check_count++;
     }
     if ($arg=param('gdlc')) {
       $trace_opt.="GDLC+";
       $check_count++;
     }
     if ($arg=param('llc2')) {
       $trace_opt.= "LLC2+";
       $check_count++;
     }
     if ($arg=param('pv')) {
       $trace_opt.="PV+";
       $check_count++;
     }
     if ($arg=param('slim')) {
       $trace_opt.="SLIM+";
       $check_count++;
     }
     if ($arg=param('gsna')) {
       $trace_opt.="GSNA+";
       $check_count++;
     }
     if ($arg=param('hprip')) {
       $trace_opt.="HPRIP+";
       $check_count++;
     }
     $trace_opt=~s/\+$//;
   #  count if anything checked, if not assume NONE is meant
     if ($check_count == 0)  {
       $trace_opt = "NONE";
     }
   }
 # get truncation length

   $trunc_length=param('trunc_length');
   $trunc_length=~s/ //g;          # delete spaces

 # Set trace
 #  commout out    print "<br> Debug: snaadmin set_trace_type,trace_flags=$trace_opt,truncation_length=$trunc_length<br>";

   @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin set_trace_type,trace_flags=$trace_opt,truncation_length=$trunc_length `;
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_;
}
print "</b><br>";
print "<br><b> Trace Status: </b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_trace_type`; # Command to get Tracestatus

foreach $line (@contents) {
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0;

