#!/usr/bin/perl -w

#  Purpose of the script is to read the BoA LU Client Mapping database
#  file and display the PU information for the domain along with 
#  the RAPI client DNS address for the PU. This calls snaadmin query_all_nodes
#  to get list of servers, then calls snaadmin -d query_dlur_pu to get 
#  the DLUR PU state of all PUs on all servers in a domain
#

use strict;

 my ( $srv_index, $srvcnt, $state, $plu_status, $pu_id, $init_act, $filename,
      $dlus_defined_name, $dlus_active_name, $puname, $dlusname, $pustate, $clientDNS,
      $dlusstatus, $line, $map_file_index, $topPrefix, $tmpPrefix, $search_index,  
      @Prefix, @DNS_name, @nextPrefix, @prevPrefix, @servername, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;
$line = 0;
#
#  There is an array of Prefix and DNS names that map to each other. Another array
#   of index's to point to the next Prefix in the list. When a match occurs in mapping
#   a Prefix to a PU (where we display the PU and the client's DNS name, then the next 
#   Prefix for the previous Prefix is updated to point to the current next Prefix. This 
#   takes the current Prefix out of the search list so list gets shorter as more PUs are
#   mapped to the client's DNS.
#
$map_file_index = 0;
$topPrefix = 0;
$prevPrefix[0] = 0;
$nextPrefix[0] = 1;
$Prefix[0] = " ";    # Initialize the zeroth prefix to blank
$filename = "/var/opt/ibm/sna/BOA_LU_client_mapping.dat";

#  read in the BOA_LU_client_mapping data base file to get PU to Financial branch server mapping
if(-e $filename)
{
  open(BOA_MAP_F, $filename) or die  "Cannot open $filename !\n";

  while(<BOA_MAP_F>)  {
    chomp;                   # remove end of line character
    $line++;
    next if ($line < 2);     # skip first line       
    @data = split(/ /,$_);   # seperator is the blank or space character
    $map_file_index = $line-1;
    $Prefix[$map_file_index] = $data[1];
    $DNS_name[$map_file_index] = $data[2];
    $nextPrefix[$map_file_index] = $line;                # link to next in list
    $prevPrefix[$map_file_index] = $map_file_index - 1;  # link to previous in list
    # debug commented out  printf(" Client index: %d, Prefix = %s, DNS address: %s \n",
    # debug commented out       $map_file_index, $Prefix[$map_file_index],$DNS_name[$map_file_index]);
  }
  close(BOA_MAP_F);
}

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_dlur_pu` or die "Node $servername[$srv_index] not recognized $!\n";

#   Print header line

   printf("\n      Server: %s\n", $servername[$srv_index]);
   print "----------- ----------------- --------  --------  --------- -----------------\n";
   print "    DLUR        DLUS           Initially                                     \n";
   print "     PU         name           Active     State     PU_id    Client address  \n";
   print "----------- ----------------- --------  --------  --------- -----------------\n";

   foreach(@status) {
      chomp;
      if (/^query_dlur_pu/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

     #  Skip headers
     next if (/^------/);
     next if (/^list_option/);
     next if (/^filter/);
     next if (/^\n/);

     @data = split(/=/,$_);   #Break parameter = value

     next if (@data == 0);        # on blank line, skip

     if ($data[0]=~m/^pu_name/) {       # get DLUR PU name  
        $puname = $data[1];    #  save PU name
        $puname=~s/ //g;       # remove any spaces as end
        next;   
     } elsif ($data[0]=~m/^defined_dlus_name/) { # Defined DLUS
        $dlus_defined_name = $data[1];    #  save defined DLUS name
        $dlus_defined_name=~s/ //g;       # remove any spaces as end
        next;                              
     } elsif ($data[0]=~m/^active_dlus_name/) { # Determined Active DLUS
        $dlus_active_name = $data[1];    #  save Active DLUS name
        $dlus_active_name=~s/ //g;       # remove any spaces as end
        next;             
     } elsif ($data[0]=~m/^pu_status/) { # PU state ... needs to be ACTIVE
        $pustate = $data[1];    #  save PU State
        $pustate=~s/ //g;       # remove any spaces as end 
        if ($data[1]=~m/ACTIVE/) {      # If active, set active, else use defined
           $dlusname = $dlus_active_name;
        } else {  
           $dlusname = $dlus_defined_name;
        }
        next;  
     } elsif ($data[0]=~m/^pu_id/) { # Needs to be ACTIVE
        $pu_id = $data[1];
        next; 
     } elsif ($data[0]=~m/^dlus_session_status/) { # Needs to be ACTIVE
        if ($data[1]=~m/_ACTIVE/) {  
            $dlusstatus = "Inactive";
        } elsif ($data[1]=~m/ACTIVE/) {
            $dlusstatus = "Active"
        }  
        next;
     } elsif ($data[0]=~m/^initially_active/) { # Initial active setting
        $init_act = $data[1];    #  save initially_active setting
        $init_act=~s/ //g;       # remove any spaces as end             
        $search_index = $topPrefix;
        $clientDNS = " ";
        $tmpPrefix = substr($puname,1);    # get last 5 chars of PU for prefix value
        while ($search_index < $line)
        {
           if($tmpPrefix eq $Prefix[$search_index])
           {
#             skip over this Prefix in list on next search
             $nextPrefix[$prevPrefix[$search_index]] = $nextPrefix[$search_index];
             $prevPrefix[$nextPrefix[$search_index]] = $prevPrefix[$search_index];
             $clientDNS = $DNS_name[$search_index];
#                   When previous is top of list, make top the next in list
             if($prevPrefix[$search_index] == 0)  
             {
                 $topPrefix = $nextPrefix[$search_index];
             }
             $search_index = $line;
           }
           else
           {
            $search_index = $nextPrefix[$search_index];
           }
        }
         printf("   %8s %17s %8s %8s %8s %8s\n",
               $puname, $dlusname, $init_act, $dlusstatus, $pu_id, $clientDNS);          
    } else {
        next;
    }

  }
  $srv_index++;
  print "\n";

}

$search_index = $topPrefix;
$clientDNS = " ";
if ($search_index < $line)
{
   print"  The following PU ID and client DNS name(s) are not defined by any PU: \n";

   while ($search_index < $line)
   {

      printf(" PU ID %s, clientDNS %s \n", 
          $Prefix[$search_index], $DNS_name[$search_index]);
#   skip over this Prefix in list on next search
      $search_index = $nextPrefix[$search_index];
   }
}
print "\n------------------------------------------------\n";

