#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin status_dependent_lu and display
#  the dependent lu used by application in the domain
#

use strict;

 my ( $srv_index, $srvcnt, $puname, $label, $value,
      @servername, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{

  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index]  status_dependent_lu` or die "Node $servername[$srv_index] not recognized $!\n";


   #   Print header line
   printf("\n=     Server: %s\n", $servername[$srv_index]);
   print "\n=  PU:    NAU:    LU:    Status:     Activity: \n";
   print "=  ===    ====    ===    =======     ========= ";


   foreach(@status) {
      chomp;
      if (/^query_node_limit/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
    }
 
  #  Skip headers
      next if (/^----/);
      next if (/^PU/);
      next if (/^\n/);      

  #  Print PUs for DLUR/DLUS
      if (/^[A-Z\@\#\$][0-9A-Z\@\#\$]+/) {
          $puname = substr($_, 0, 8);
          next;
      }

      @data = split(/[\s]+/,$_);   #Break NAU, LU, Type, Status

      next if (@data == 0);        # on blank line, skip

      if ($data[1]=~m/TN3270/) {       # get IP address of client
           ($label, $value) = split(":",$data[2]);
           printf( "=> %s, ",$value);
           
      } elsif ($data[1]=~m/Telnet/) {  # either port or type of client
           ($label, $value) = split(":",$data[2]);
           printf("%s, ", $value);
           
      } elsif ($data[1]=~m/^Security/) { #level of session security
           ($label, $value) = split(":",$data[1]);
           $value=~s/ //g;              # blank out extra blanks
           printf("Sec. = %s ", $value);
           
      } elsif ($data[1]=~m/^LUA/) { # LUA session running
        print "$data[2] = $data[1] ";

      } elsif ($data[1]=~m/^[^0-9]+/) { # any data not starting with a digit
        print "$data[1] ";

      } elsif ($data[1]=~m/[^0-9]+/) { # any data  starting with a digit
          print "$data[1] ";
      } else {                     # output NAU, LU status line
        printf("\n %s %3d %8s  %6s ", 
                   $puname, $data[1], $data[2], $data[4]);
      }
   }
   print "\n------------------------------------------------\n";
   $srv_index++;
}


