#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2015 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:all);
use strict;

my ($time, $arg, $line, @contents,@title);
$arg=" ";

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
print "<font face=\"Courier, Helvetica\" height=\"10\" width=\"10\"";   # Force to mono-space

#! if parameter grep is set, call dlustat and grep on the '='
$arg=param('grep');
if ($arg=~/^dlustatactive/) {
    @title = "<b>CS Display Dependent LU Active status: $time </b><br>";
    @contents =  `../cscbin/dlustat.pl | /bin/grep =`;
} elsif ($arg=~/^sna_display_domain_pu/) {
    @title = "<b>Domain PUs : $time </b><br>";
    @contents =  `../cscbin/sna_display_domain_pu.pl`;    
} elsif ($arg=~/^sna_display_active_lu/) {
    @title = "<b>Domain LUs 0-3 resources: $time </b><br>";
    @contents =  `../cscbin/sna_display_active_lu.pl`;
} elsif ($arg=~/^sna_display_active_plu/) {
    @title = "<b>Domain LUs 0-3 with active sessions : $time </b><br>";
    @contents =  `../cscbin/sna_display_active_plu.pl`;
} elsif ($arg=~/^sna_domain_totals/) {
    @title = "<b>Domain SNA Totals : $time </b><br>";
    @contents =  `../cscbin/sna_domain_totals.pl`;
} elsif ($arg=~/^sna_display_rapi_clients/) {
    @title = "<b>Domain RAPI Client list: $time </b><br>";
    @contents =  `../cscbin/sna_display_rapi_client.pl`;       
} elsif ($arg=~/^sna_domain_d_l/) {
    @title = "<b>Domain Link stations and PU status: $time </b><br>";
    @contents =  `../cscbin/sna_domain_d_l.pl`;    
} elsif ($arg=~/^sysname62_domain/) {
    @title = "<b>Domain LU 6.2 mapping to clients: $time </b><br>";
    @contents =  `../cscbin/sysname62_domain.pl`;
} elsif ($arg=~/^statuslu62_domain/) {
    @title = "<b>Domain LU 6.2 status for whole domain: $time </b><br>";
    @contents =  `../cscbin/statuslu62_domain.pl`;    
} elsif ($arg=~/^dlustatTN3270/) {
    @title =  "<b>CS Display Active Dependent LU sessions: $time </b><br>";
    @contents = `../cscbin/dlustat.pl | /bin/grep = | /bin/grep -v Applic`;
} elsif ($arg=~/^dlustat/) {
    @title =  "<b>CS Display Dependent LU status: $time </b><br>";
    @contents =  `../cscbin/dlustat.pl`;
} elsif ($arg=~/^sna_display_dlu_app/) {
    @title =  "<b>Domain Active Dependent LU Application: $time </b><br>";
    @contents =  `../cscbin/dlustat_app_domain.pl | /bin/grep -E "=|--"`;
} elsif ($arg=~/^dlupool/) {
    @title = "<b>CS Display LU Pool status: $time </b><br>";
    @contents =  `../cscbin/dlupool.pl`;
} elsif ($arg=~/^hprlinks/) {
    @title = "<b>CS Link Station HPR Information: $time</b><br>";
    @contents=`../cscbin/cslinks.pl | /bin/grep -v " NONE "`;   # HPR Links only
} elsif ($arg=~/^cslinks/) {
    @title = "<b>CS Link Station Information: $time</b><br>";
    @contents=`../cscbin/cslinks.pl`;     # Command to get Link Station status
} elsif ($arg=~/^dpustat/) {
    @title = "<b>PU Status Information: $time</b><br>";
    @contents=`../cscbin/dpustat.pl`;     # Command to get PU status
} elsif ($arg=~/^rtpconn/) {
    @title = "<b>CS Display RTP Connection Summary: $time </b><br>";
    @contents =  `../cscbin/rtpconn.pl`;
} elsif ($arg=~/^sessconn/) {
    @title = "<b>CS Display Session Summary: $time </b><br>";
    @contents =  `../cscbin/sessconn.pl`;
} elsif ($arg=~/^sysname62/) {
    @title = "<b>Remote API Client mapping to Independent LU6.2: $time </b><br>";
    @contents =  `../cscbin/sysname62.pl`;
} elsif ($arg=~/^sessdisplaydetails/) {
    @title = "<b>Query Session Details: $time </b><br>";
    @contents =  `../cscbin/sessdisplaydetails.pl`;
} elsif ($arg=~/^sessdisplay/) {
    @title = "<b>Query Sessions: $time </b><br>";
    @contents =  `../cscbin/sessdisplay.pl`;
} elsif ($arg=~/^tpdisplay/) {
    @title = "<b>Active Outbound Transaction Programs: $time </b><br>";
    @contents =  `../cscbin/tpdisplay.pl`;
} elsif ($arg=~/^convdisplay/) {
    @title = "<b>Query Active Conversations: $time </b><br>";
    @contents =  `../cscbin/convdisplay.pl`;
} elsif ($arg=~/^domain_convdisplay/) {
    @title =  "<b>Domain Active APPC Conversations: $time </b><br>";
    @contents =  `../cscbin/convdisplay_domain.pl`;
} elsif ($arg=~/^tnredirector/) {
    @title =  "<b>CS Display TN Redirector Sessions: $time </b><br>";
    @contents = `../cscbin/dtnredirect.pl`;
} else {
  @title =  " UNKNOWN COMMAND <br>";
}
#  Print title
foreach $line (@title) {
   chomp $line;
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
#Print output
foreach $line (@contents) {
   chomp $line;
#  On none active lines, print end of list in html format
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
print "</p></form></font>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

