#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use Digest::MD5 qw(md5_hex);
use strict;
#
#   This "require" file contains print_top(), print_bottom(),
#    and build_token() subroutines called by most CGI scripts 
#    that build the pages and needs a token to verify 
#    proper script flows on excution
#
#
#  Write header of page for admin
#
sub print_top {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}

#
#  Write header of page for admin
#
sub print_bottom {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}

#  
#   Build a token that is the remote IP address "_" remote_IP_port if client
#     and "_" up_time (in hundreths of second) for the node.
#
#     INPUT: remote_addr  = IP address of client
#            remote_port  = HTTP User Agent information 
#
#    OUTPUT: up_time of node which is 100ths of seconds count since node activation
#            hash = MD5 checksum of remote_add_remote_port_uptime. 
#
#    ERROR: If node is not started, query_node fails, return 0000 for up_time and 
#           FFFF for hash
#
sub build_token {

   my ($hash, $token, $up_time, $line, @data, @contents);
   my ($remote_addr, $remote_port) = @_;
#
#  Get the up_time from the query_node details to use for token
#  Build token from IP addr_IP port_uptime. 
#  Hash value is checksum to validate is matches when processed.
#
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
# Display output of snaadmin query_node
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters

      if ($line=~m/failed :/) {
        # Return error codes indication node not available
           $up_time = "0000";
           $hash = "FFFF";
           return ($up_time, $hash);
      }

      if ($line=~m/up_time/) {
         @data = split(/=/,$line);   #Break time in hundreths of second
         $data[1]=~s/^\s+//;         #Get rid of leading blanks
         $data[1]=~s/\s+$//;         #Get rid of trailing blanks
         $up_time =$data[1];
         if ($up_time =~ m/[^0-9]/) {
            print "</p><p> Invalid Character in query_node up_time field !! </p></form></font>";
            exit -2;
         }
         next;

      } else {
        next;
      }
   }
#
#  Calculate token and then get hash value 
#
   $token = $remote_addr."_".$remote_port."_".$up_time;
   $hash = md5_hex($token);
   return ($up_time, $hash);
}

1;
