#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################

use strict;


 my ($filename, $line, @data,
    $APPC_curr, $APPC_max,   $LUA_curr,$LUA_max,
    $ls_curr,  $ls_max,$TN3270_curr,$TN3270_max,
    $TNRed_curr,$TNRed_max,$sess_curr,$sess_max,
    $V4lu6_curr, $V4lu6_max, $V4lu0_curr, $V4lu0_max,
    $first_year, $last_year, $first_month, $last_month,
    $first_day, $last_day, $first_time, $last_time,
    $AIX_version, $redirect_version);

#  Initialize for scalar declaration

   $APPC_curr = $APPC_max = $LUA_curr = $LUA_max = 0;
   $ls_curr = $ls_max  = $TN3270_curr = $TN3270_max = 0;
   $TNRed_curr = $TNRed_max = $sess_curr = $sess_max = 0;
   $V4lu6_curr = $V4lu6_max = $V4lu0_curr = $V4lu0_max = 0;
   $first_year = 99999;

if ($#ARGV < 0)    # Check for input argument on line
{
    print "usage: usage.pl <sna.usage file path>\n";
    print "    If sna.usage file path is not provided, prompts for name. \n";
    print "    \n";
    print "Enter filename to process stats on: ";
    $filename = <STDIN>; chomp $filename;


} else {
$filename = $ARGV[0];
}

open (PH,$filename) or die "Cannot open $filename $!\n";
$line =0;
while(<PH>) {
   $line++;
   if (/^APPC/)  {  # Skip comment - header lines
     $redirect_version = 0;
     $AIX_version = 0;
     if (/LU0/) {
         $AIX_version = 1;  # on AIX, there is LU6 - LU1-3 and LU0
     }
     if (/redirect/) { 
         $redirect_version = 1
     }
     next;
   }
   next if (/^Current/);  # Skip comment lines
   next if (/^----/);
   next if (/^====/);
   next if (/^\n/);

   @data = split(/[\s\/|]+/,$_);   #Break APPC, LUA, TN3270... sections

   if ($APPC_curr < $data[1])   { $APPC_curr = $data[1];  }
   if ($APPC_max < $data[2])    { $APPC_max = $data[2];   }
   if ($LUA_curr < $data[3])    { $LUA_curr = $data[3];   }
   if ($LUA_max < $data[4])     { $LUA_max = $data[4];    }
   if ($ls_curr < $data[5])     { $ls_curr = $data[5];    }
   if ($ls_max < $data[6])      { $ls_max   = $data[6];   }
   if ($TN3270_curr < $data[7]) { $TN3270_curr = $data[7];}
   if ($TN3270_max < $data[8])  { $TN3270_max = $data[8]; }
   if ($redirect_version) {
     if ($TNRed_curr < $data[9])  { $TNRed_curr = $data[9]; }
     if ($TNRed_max < $data[10])  { $TNRed_max = $data[10]; }

   # Check for AIX verse Linux
     if ($AIX_version)  {
       if ($V4lu6_curr < $data[11])   { $V4lu6_curr = $data[11];  }
       if ($V4lu6_max < $data[12])    { $V4lu6_max = $data[12];   }
       if ($V4lu0_curr < $data[13])   { $V4lu0_curr = $data[13];   }
       if ($V4lu0_max < $data[14])    { $V4lu0_max = $data[14];    }
       if ($sess_curr < $data[15])    { $sess_curr = $data[15]; }
       if ($sess_max < $data[16])     { $sess_max = $data[16];  }

 #   Set first time stamp values
       if ($first_year > $data[17]) { $first_year = $data[17];
            $first_month = $data[18]; $first_day = $data[19];
            $first_time = $data[20]
       }
  #  Save last time stamp
       $last_year = $data[17]; $last_month = $data[18];
       $last_day = $data[19];  $last_time = $data[20]      
     }
     else   # On AIX, but CSDCD V7, no V4 LU0 records
     {
       if ($sess_curr < $data[11])    { $sess_curr = $data[11]; }
       if ($sess_max < $data[12])     { $sess_max = $data[12];  }

 #   Set first time stamp values
       if ($first_year > $data[13]) { $first_year = $data[13];
            $first_month = $data[14]; $first_day = $data[15];
            $first_time = $data[16]
       }
  #  Save last time stamp
       $last_year = $data[13]; $last_month = $data[14];
       $last_day = $data[15];  $last_time = $data[16]
       }
   }
   else  #  No redirector records to count, V7
   {
     if ($sess_curr < $data[9])    { $sess_curr = $data[9]; }
     if ($sess_max < $data[10])     { $sess_max = $data[10];  }

 #   Set first time stamp values
     if ($first_year > $data[11]) { $first_year = $data[11];
          $first_month = $data[12]; $first_day = $data[13];
          $first_time = $data[14]
     }
  #  Save last time stamp
     $last_year = $data[11]; $last_month = $data[12];
     $last_day = $data[13];  $last_time = $data[14]

  }

}
close(PH);

  if ($AIX_version) {
     print "\n Maximum AIX usage count in 'Current / Peak' form\n";
  } else {
     print "\n Maximum Linux usage count in 'Current / Peak' form\n";
  }
  print "   for times: $first_year/$first_month/$first_day $first_time -";
  print " $last_year/$last_month/$last_day $last_time \n";
  print "APPC sessions: $APPC_curr / $APPC_max, \n";
  print "LUA sessions: $LUA_curr / $LUA_max, \n";
  print "Links stations: $ls_curr / $ls_max, \n";
  print "TN3270 sessions: $TN3270_curr / $TN3270_max, \n";
  if ($redirect_version) {
  print "TN Redirector connections: $TNRed_curr / $TNRed_max, \n";
  }
  if ($AIX_version) {
    print "V4 LU6, LU1-3 sessions: $V4lu6_curr / $V4lu6_max, \n";
    print "V4 LU0 sessions: $V4lu0_curr / $V4lu0_max, \n";
  }
  print "Data Sessions (PLU-SLU): $sess_curr / $sess_max \n";

