#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2013 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin query_tp,lu_alias= and display
#  in a terse format the information.


use strict;

 my ( $tpname, $luname, $display_flag, $count_flag,$len,@data, @status );

#  Initialize for scalar declaration
$tpname = " ";
$display_flag = 0;
$count_flag = 0;

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`../cscbin/query_all_active_tp.sh`;

}

$len = @status;
if($len == 0){
   print " Cannot process node \n";
   exit -1;
}
    
#   Print header line


foreach(@status) {

   chomp;
   if (/^query_tp/) {
     $display_flag = 1;
   }

  #  Skip headers
#   next if (/^------/);
   if (/^--------/) {       #  reset display flag 
     $display_flag = 0;
     next;
   }elsif ($display_flag > 0 ) { # display any line when this flag is set
     print "$_\n";
     next;
   }
      
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break label with value

   next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

   if ($data[0]=~m/^lu_name/) {       # get lu_alias for LU invoking this TP
     $luname = $data[1];
     $luname=~s/ //g;
     next;
   }elsif ($data[0]=~m/^tp_name/) {  # Get TP name
     $tpname = $data[1];
     $tpname=~s/ //g;
     printf("\n LU Name: %8s, TP Name: %1s \n",$luname, $tpname);
     $display_flag = 1;
     $count_flag = 1;
     next;
   }
   
}
if ($count_flag == 0) {
  printf("\n --- No Transaction Programs found --- \n");
} 
print "\n------------------------------------------------\n";

