#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_node_all to get 
#  list of domain servers, then search servers and display LU status
#  for LU 0-3 specified in argument
#

use strict;

 my ( $srv_index, $srvcnt, $lusrvcnt, $puname, $state, 
      $luname, $found_index, $input_luname, $total_cnt_lus,  
      @servername, @luservername, @luserverindex, @lucount, @data, @status);

#  Initialize for scalar declaration
$srvcnt = 0;
$lusrvcnt = 0;
$srv_index = 0;
$total_cnt_lus = 0;

if ($#ARGV < 0)    # Check for input argument on line
{
   print ("\n   No Dependent LU to search for provided as input parameter. \n");
   $input_luname = "[]";      # set input_luname to something a LU cannot be
}else {
   $input_luname = $ARGV[0];
   printf("\n Searching for Dependent LU %s in the following domain servers:\n\n",$input_luname);
}


@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information


foreach(@status) {
   chomp;
   if (/^query_ls/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get name of each domain server   
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
print "\n------------------------------------------------\n";
   
#
#  Process the Local LU information
#

while ($srv_index < $srvcnt) 
{
   $lucount[$srv_index]=0;  # Initialize count of LUs on this server

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] query_lu_0_to_3 | grep -B 6 -A 1 "appl_conn_active = "` or die "Node $servername[$srv_index] not recognized $!\n";

   foreach(@status) {
      chomp;
      if (/^query_lu_0_to_3/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

     #  Skip headers
     next if (/^------/);
     next if (/^list_option/);
     next if (/^\n/);

     @data = split(/=/,$_);   #Break parameter = value

     next if (@data == 0);        # on blank line, skip

     if ($data[0]=~m/^lu_name/) {       # get LU name  
        $luname = $data[1];    #  save LU name
        $luname=~s/ //g;       # remove any spaces as end
        if ($input_luname=~m/$luname/) {
           $luserverindex[$lusrvcnt] = $srv_index;   # Save the index into server list
           $lusrvcnt++;
        } 
        $lucount[$srv_index]++;    # Array of counts for LUs on each server
        $total_cnt_lus++;
        next;   
     } elsif (!($input_luname=~m/$luname/)) {  # only look for the LU name provided
        next;
     } elsif ($data[0]=~m/^pu_name/) { # get PU name
        $puname = $data[1];    #  save PU name
        $puname=~s/ //g;       # remove any spaces as end
        next;                              
     } elsif ($data[0]=~m/^plu_sess_active/) { # Primary LU active state
        $state = $data[1];    #  save PLU state
        $state=~s/ //g;       # remove any spaces as end   
#   Print header line          
        printf("\n      Server: %s\n", $servername[$srv_index]);
        print "----------- ------------ -------- \n";
        print "    DLUR        LU         PLU\n";
        print "     PU         name       Active\n";
        print "----------- ------------ -------- \n";

         printf("   %8s %8s %8s\n", $puname, $luname, $state);       
    } else {
        next;
    }

  }
  $srv_index++;
#  print "\n-------------------------------------------\n";

}

if ($lusrvcnt == 0) {
  printf("\n  Dependent LU %s not found in domain servers.\n", $input_luname);
}
else
{
  printf("\n   Dependent LU %s found on %d server(s)\n", $input_luname, $lusrvcnt);
}
print "\n------------------------------------------------\n";

