#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_sna_net and display
#  the DLUR LU state where the partner LU (PLU) state is active.
#

use strict;

 my ( $srv_index, $srvcnt, $state, $luname, $puname, $partner_lu_name,  
      @servername, $dlusstatus, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_lu_0_to_3 | grep -B 4 -A 56 "plu_sess_active = YES"` ;
#   Print header line

   printf("\n      Server: %s\n", $servername[$srv_index]);
   print "----------- ------------ -------- ---------\n";
   print "    DLUR        LU         PLU     Partner LU\n";
   print "     PU         name       Active    Name\n";
   print "----------- ------------ -------- ----------- \n";

   foreach(@status) {
      chomp;
      if (/^query_lu_0_to_3/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

     #  Skip headers
     next if (/^------/);
     next if (/^list_option/);
     next if (/^filter/);
     next if (/^\n/);

     @data = split(/=/,$_);   #Break parameter = value

     next if (@data == 0);        # on blank line, skip

#     printf(" debug: %s \n",$data[0]);

     if ($data[0]=~m/^lu_name/) {       # get LU name  
        $luname = $data[1];    #  save LU name
        $luname=~s/ //g;       # remove any spaces as end
        next;   
     } elsif ($data[0]=~m/^plu_sess_active/) { # Primary LU active state
        $state = $data[1];    #  save PLU state
        $state=~s/ //g;       # remove any spaces as end
        next;
     } elsif ($data[0]=~m/^plu_name/) { # Partner LU name
        $partner_lu_name = $data[1];    #  save PLUname
        $partner_lu_name=~s/ //g;       # remove any spaces as end             
        next;
     } elsif ($data[0]=~m/^pu_name/) { # get PU name
        $puname = $data[1];    #  save PU name
        $puname=~s/ //g;       # remove any spaces as end
        printf("   %8s %8s %8s     %8s\n", $puname, $luname, $state, $partner_lu_name);
        next;          
    } else {
        next;
    }

  }
  $srv_index++;
#  print "\n-------------------------------------------\n";

}

print "\n------------------------------------------------\n";

