#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($time, $linecount, $halfcount, $i, @puname, @putype, 
    @puactive, $line, $outputline, $remote_addr, $remote_port, 
    $saveline, @links, @retval);

print header;

# output top of template page
print_top();

$linecount=0;
$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#! Get DPUSTAT output
@links=`../cscbin/dpustat.pl`;

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/actpuform.cgi\" method=\"post\">\n";
print "<br><b> PU Status: $time <br>";
print "<br> DLUR attached PUs are the only PUs that can be started/stopped by administration. \n";
print "Use Link Station management to start/stop directly attached PUs.</b>\n";
print "<br><br>";
print "<p>\n";
#
# display current PU status and get PU information
#
foreach $line (@links) {
   $saveline = $line;
#  On none active lines, print end of list in html format
   $line=~s/ /&nbsp;/g;
   print $line."<br>\n";
   if ($saveline=~m/DLUR_ATTACH/) {     # get active or Inactive links names
#     extract link name from first and cp name from third output
     ($puname[$linecount], $puactive[$linecount]) = (split(/\s+/,$saveline) )[1,3]; 
      if ($puactive[$linecount]=~m/NO/) {    #  If the PU is not active, set PU type to start
         $putype[$linecount] = "INACTIVE";
      } elsif ($puactive[$linecount]=~m/YES/) {     # get active PU to stop
         $putype[$linecount] = "ACTIVE  ";
      } 
      $linecount++;
   }
}
#
#   Process lines read for action to set up
#
if ($linecount == 0) {    # No links to start or stop
   print_bottom();
   exit 0;
}
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
# 
if ($linecount == 1) {    # Print only one line
   if ($putype[$i]=~m/^INACTIVE/) {    #  If the link is not active
      $outputline = "<b>Start</b><input type=\"radio\" name=\"pulist\" value=\"start_$puname[$i]\"/>";
   } elsif ($putype[$i]=~m/^ACTIVE/) {     # list active links to stop
      $outputline = "<b>Stop </b><input type=\"radio\" name=\"pulist\" value=\"stop_$puname[$i]\"/>";
   } 
   $outputline.= " $puname[$i] - $putype[$i] <br>";
   print "&nbsp;$outputline<br>\n";
} else  { # linecount is 2 or greater
#
#  Build table (2 columns) of link execution radio buttons
#
   print "</p><table><tr><td> <strong> Select A DLUR PU To Start Or Stop: </strong></td><tr>\n";
   print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
   print "<tbody><tr><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   if (($linecount % 2) == 1) { # if odd, add one to get proper split point
        $halfcount = ($linecount + 1) /2;
   } else {
        $halfcount = $linecount/2;
   }
   for ($i=0; $i < $halfcount; $i++) {
      if ($putype[$i]=~m/^INACTIVE/) {    #  If the PU is not active
         $outputline = "<b>Start</b><input type=\"radio\" name=\"pulist\" value=\"start_$puname[$i]\"/>";
      } elsif ($putype[$i]=~m/^ACTIVE/) {     # list active PUs to stop
         $outputline = "<b>Stop </b><input type=\"radio\" name=\"pulist\" value=\"stop_$puname[$i]\"/>";
      } 
      $outputline.= " $puname[$i]  -  $putype[$i] <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   for ($i=$halfcount; $i < $linecount; $i++) {
      if ($putype[$i]=~m/^INACTIVE/) {    #  If the PU is not active
         $outputline = "<b> | Start</b><input type=\"radio\" name=\"pulist\" value=\"start_$puname[$i]\"/>";
      } elsif ($putype[$i]=~m/^ACTIVE/) {     # list active PU to stop
         $outputline = "<b> | Stop </b><input type=\"radio\" name=\"pulist\" value=\"stop_$puname[$i]\"/>";
      } 
      $outputline.= " $puname[$i]  -  $putype[$i] <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td></tr></tbody></table></table>";
   print "<br>";
}
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
