#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2006, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($time, $linecount, $halfcount, $i, $remote_addr, $remote_port, 
    $label, @portname, @porttype, @portstate, $line, $outputline, 
    $saveline, @ports, @retval);

print header;

# output top of template page
print_top();

$linecount=0;
$time=localtime;

#! Get Port status by query
@ports=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port`;

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/actportsform.cgi\" method=\"post\">\n";
print "<br><b> Port Status: $time</b>";
print "<p>\n";
#
# display current port status and get port information
#
foreach $line (@ports) {
   $saveline = $line;
   if ($saveline=~m/port_name/) {
       ($label, $portname[$linecount]) = (split(/=/,$saveline) );
       $portname[$linecount]=~s/\s+//g;        # Remove blanks
#  Display port name first on a line
      $line=~s/ /&nbsp;/g;
      print $line."  ";
      print "status: ";
   } elsif ($saveline=~m/port_state/) {
#  Get state that is active or inactive
      ($label, $portstate[$linecount]) = (split(/=/,$saveline) );

      if ($saveline=~m/NOT_ACTIVE/) {     # get active or Inactive port names
#  extract port name from first and cp name from third output
	 $porttype[$linecount] = "Start ";
      } else {  # get active port to start
         $porttype[$linecount] = "Stop  ";
      }
      print $portstate[$linecount]."<br>\n";
      $linecount++;
   }
}
#
#   Process lines read for action to set up
#
if ($linecount == 0) {    # No port to start or stop
   print_bottom();
   exit 0;
} 
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
if ($linecount == 1) {    # Print only one line
   if ($porttype[$i]=~m/^Start/) {    #  If the port is not active
      $outputline = "<b>Start</b><input type=\"radio\" name=\"portslist\" value=\"start_PoRtNaMe_$portname[$i]\"/>";
   } elsif ($porttype[$i]=~m/^Stop/) {     # list active ports to stop
      $outputline = "<b>Stop </b><input type=\"radio\" name=\"portslist\" value=\"stop_PoRtNaMe_$portname[$i]\"/>";
   }
   $outputline.= " $portname[$i]  <br>";
   print "&nbsp;$outputline<br>\n";
} else  { # linecount is 2 or greater
#
#  Build table (2 columns) of port execution radio buttons
#
   print "</p><table><tr><td> <strong> Select A Port To Start Or Stop: </strong></td><tr>\n";
   print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
   print "<tbody><tr><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   if (($linecount % 2) == 1) { # if odd, add one to get proper split point
        $halfcount = ($linecount + 1) /2;
   } else {
        $halfcount = $linecount/2;
   }
   for ($i=0; $i < $halfcount; $i++) {
      if ($porttype[$i]=~m/^Start/) {    #  If the port is not active
         $outputline = "<b>Start</b><input type=\"radio\" name=\"portslist\" value=\"start_PoRtNaMe_$portname[$i]\"/>";
      } elsif ($porttype[$i]=~m/^Stop/) {     # list active ports to stop
         $outputline = "<b>Stop </b><input type=\"radio\" name=\"portslist\" value=\"stop_PoRtNaMe_$portname[$i]\"/>";
      }
      $outputline.= " $portname[$i]  <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   for ($i=$halfcount; $i < $linecount; $i++) {
      if ($porttype[$i]=~m/^Start/) {    #  If the port is not active
         $outputline = "<b> | Start</b><input type=\"radio\" name=\"portslist\" value=\"start_PoRtNaMe_$portname[$i]\"/>";
      } elsif ($porttype[$i]=~m/^Stop/) {     # list active ports to stop
         $outputline = "<b> | Stop </b><input type=\"radio\" name=\"portslist\" value=\"stop_PoRtNaMe_$portname[$i]\"/>";
      }
      $outputline.= " $portname[$i]  <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td></tr></tbody></table></table>";
   print "<br>";
}
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
