#!/usr/bin/perl -w
##############################################################
#                                                            #
# Copyright IBM Corporation 2004, 2025  All rights reserved. #
#                                                            #
##############################################################
use CGI qw(:all);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($time, $linecount, $nodename, $nodeact, $remote_addr, $remote_port, 
    $nodehit, $line, $outputline, $saveline, @nodestat, @retval);

print header;

# output top of template page
print_top();

$linecount=0;
$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
#! Get Status node  output
@nodestat=`/bin/ps -A | /bin/grep snadaemon`;
$nodehit = 0;    # flag to track that "Node " has been read
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/actnodeform.cgi\" method=\"post\">\n";
print "<br><b> SNA Kernel Status: $time</b>";
print "<p>\n";
#
#
# display current snadaemon status 
#
foreach $line (@nodestat) {   
#  Look for snadaemon, if found, SNA kernel is running 
   if ($line=~m/snadaemon/) {     # get active or Inactive SNA kernel 
      $nodehit = 1;
   }
}
# Process what we know about SNA kernel
if ($nodehit == 0) {       # provide SNA Kernel start option
    print " ** SNA kernel daemons are not running ** <br>";
    $outputline = "Start <b>SNA Kernel</b> to activate SNA processes<input type=\"checkbox\" name=\"nodelist\" value=\"alive_node\"/>";
} else {
    print " ** SNA kernel daemons are active ** <br>";
    $outputline = "Stop <b>SNA Kernel</b> and all SNA processes<input type=\"checkbox\" name=\"nodelist\" value=\"dead_node\"/>";
}
print "<br>&nbsp;$outputline<br><br>\n";
print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";
print "        <input type=\"reset\" name=\"reset\" value=\"Reset\"/>";
#  Print dividing line
print "</p></form>";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"\>\n";
print "<td colspan=\"2\" width=\"100%\"\>\n";
print "<hr size=\"1\" align=\"left\" width=\"100%\" color=\"#000000\" noshade=\"noshade\"\>\n";
print "</td\> </table\>\n";

# print "<br>==========================================================<br>\n";
if ($nodehit) {     # The SNA kernel is running, so provide way to start/stop the node
   print "<form action= \"/cscbin/actnodeform.cgi\" method=\"post\">\n";
   print "<b>&nbsp;SNA Node Status:</b>";
   print "<p>\n";
  $nodehit = 0;   # reset flag
#
#   Process lines read for action to set up
#

#! Get Status node  output
  @nodestat=`sudo -u snauser /opt/ibm/sna/bin/snaadmin status_node`;
#
# display current node status
#
  foreach $line (@nodestat) {
     $saveline = $line;
#  On none active lines, print end of list in html format
     $line=~s/ /&nbsp;/g;
     $line=~s/\-\-/==/g;
     print $line."<br>\n";
     if ($saveline=~m/^Node /) {     # get active or Inactive node 
        $nodehit = 1;
        next;
     }
     next if ($nodehit == 0);        # skip first records until Node is hit
     if ($saveline=~m/^\w/) {
#  extract Node name and status from first line of Node information
        $nodename=substr($saveline,0,32);
#        $nodeact=substr($saveline,15,8);

#        if ($nodeact=~m/Inactive/) {    #  If the node is not active, set node type to start
        if ($saveline=~m/Inactive/) {    #  If the node is not active, set node type to start
           $outputline = "<b>Start</b><input type=\"checkbox\" name=\"nodelist\" value=\"start_$nodename\"/>";
           $nodeact="Inactive";
        } else    {     # get active nodes to stop
           $outputline = "<b>Stop </b><input type=\"checkbox\" name=\"nodelist\" value=\"stop_$nodename\"/>";
           $nodeact="Active";
        }
        $nodehit = 0;   # Reset flag to ignore rest of information after Node name 
     }
  }
#
#   Process lines read for action to set up
#
  print "<br> Node name\: <b>$nodename</b>,  Node status\: <b>$nodeact </b>\n<br>";
  $outputline.= " $nodename <br>";
  print "<br>&nbsp;$outputline<br>\n";
  @retval = build_token($remote_addr, $remote_port);
  $up_time = $retval[0];
  $hash = $retval[1];

  print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

  print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

  print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";
  print "        <input type=\"reset\" name=\"reset\" value=\"Reset\"/>";

  print "</p></form></font>";

}   # End of print section for node control

#   output the bottom of the template
print_bottom();
