#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004, All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($time,  $line, @tracesettings, $check_type, $remote_addr, $remote_port, 
      $label, $trace_all, @retval);

print header;

# output top of template page
print_top();

$trace_all =0;   # flag if ALL DLC resources are on
$check_type=0;   # flag if NO DLC resources are on
$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#! Get CSLINKS output
@tracesettings=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc_trace`;

print "<font face=\"Times New Roman, Helvetica\">";
print "<br><b> Select DLC Trace Options: $time</b>";
print "<br><br>  Current DLC Trace status:<br>\n";
print "<form action= \"/cscbin/actcsdlctrace.cgi\" method=\"post\">\n";

#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
# display current client/server  trace options
#
foreach $line (@tracesettings) {
   next if $line=~m/^-------/;       # skip border
   next if $line=~m/list_opt/;       # skip list options flag
   next if $line=~m/No record/;      # NO DLC types are set
   next if !$line=~m/\w+/;      # NO DLC types are set
   if ($line=~m/^resource_type/) {     # start reading traces
      $check_type = 1;               # flag that there are some types
      if ($line=~m/ ALL_RESOURCE/) {  #  If trace is off, mark it and go to next line
          $trace_all = 1;
      }
   }
   print $line."<br>\n";
}
if ($check_type == 0) {
  print "DLC tracing is not enabled.<br>\n";
}
#  Print seperator line
print " <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
print "<td colspan=\"2\" width=\"100%\">\n";
print "<hr size=\"1\" align=\"left\" width=\"100%\" color=\"#000000\" noshade=\"noshade\">\n";
print "</td></table> <table>\n";
#
#   Process lines read for action to set up
#

if (($check_type == 0) || ($trace_all == 0)) {  # If None or only some DLC tracing 
   print "<table><tr><td> Select <b>ON</b> to enable DLC trace: ";
   print "<b>ON </b><input type=\"checkbox\" name=\"traceopt\" value=\"all\"/>";
} else  {  # ALL flag is set
   print "<table><tr><td> Select <b>OFF</b> to turn off DLC trace: ";
   print "<b>OFF </b><input type=\"checkbox\" name=\"traceopt\" value=\"none\"/>";
}
print "</td></tr></tbody></table></table>";
print "<br>";
#
#  Set the token infomation for execution validation
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";
print "   <input type=\"reset\" name=\"reset\" value=\"Reset\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
