#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($time, $linecount, $halfcount, $i, $remote_addr, $remote_port, @data,
     @data2, @data3, @data4, @cpname, @caname, @default, @llaname, $line,
    $outputline, $saveline, @links, @contents, @retval);
print header;
print_top();

$time=localtime;
$i=0;
$linecount=0;
@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn_redirect_def`;


print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/remred.cgi\" method=\"post\">\n";
print "<br><b> $time</b>";
print "<p>\n";
foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/client_port/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @cpname, $data[1];
        }
	elsif ($line=~m/client_address/) {
	    @data2 = split(/=/,$line);
            $data2[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @caname, $data2[1];   
        }
	elsif ($line=~m/listen_local_address/) {
            @data3 = split(/=/,$line);
            $data3[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @llaname, $data3[1];
        }
        elsif ($line=~m/default_record/) {
            @data4 = split(/=/,$line);
            $data4[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @default, $data4[1];
        }
	next;
}

$linecount=@cpname;

if ($linecount == 0) {
    print "No TN redirector to remove";
    exit 0;

}
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
$remote_port=$ENV{HTTP_USER_AGENT};
#
if ($linecount == 1) {
    print "<strong> Select A TN redirector To Remove: </strong>\n";
    print "<br/>\n";
    print "<br/>\n";
    $outputline = "<b>Remove</b><input type=\"radio\" name=\"linkslist\" value=\"remove_RiDiReCtOr_$cpname[$i]_RiDiReCtOr_$default[$i]_RiDiReCtOr_$caname[$i]_RiDiReCtOr_$llaname[$i]\"/>";
#    if ($caname[$i] eq "<DEFAULT>"){
    if ($default[$i] eq "YES"){
	if ($llaname[$i] eq "\"\""){
           $outputline.= "Port:$cpname[$i] <br>";
	} else{
	   $outputline.= "Port:$cpname[$i]_listen:$llaname[$i] <br>";
        }
    } else {

        if ($llaname[$i] eq "\"\""){
           $outputline.= "Port:$cpname[$i]_address:$caname[$i] <br>";
        } else{
           $outputline.= "Port:$cpname[$i]_address:$caname[$i]_listen:$llaname[$i] <br>";
        }
    }
    print "&nbsp;$outputline<br>\n";

} else  { # linecount is 2 or greater
#
#  Build table (2 columns) of link execution radio buttons
#  
   print "</p><table><tr><td> <strong> Select A TN redirector To Remove: </strong></td><tr>\n";
   print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"110%\">\n";
   print "<tbody><tr><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   if (($linecount % 2) == 1) { # if odd, add one to get proper split point
        $halfcount = ($linecount + 1) /2;
   } else {
        $halfcount = $linecount/2;
   }
   for ($i=0; $i < $halfcount; $i++) {
    $outputline = "<b>Remove</b><input type=\"radio\" name=\"linkslist\" value=\"remove_RiDiReCtOr_$cpname[$i]_RiDiReCtOr_$default[$1]_RiDiReCtOr_$caname[$i]_RiDiReCtOr_$llaname[$i]\"/>";
#    if ($caname[$i] eq "<DEFAULT>"){
    if ($default[$i] eq "YES"){
	if ($llaname[$i] eq "\"\""){
           $outputline.= "Port:$cpname[$i] <br>";
	} else{
	   $outputline.= "Port:$cpname[$i]_listen:$llaname[$i] <br>";
        }
    } else {

        if ($llaname[$i] eq "\"\""){
           $outputline.= "Port:$cpname[$i]_address:$caname[$i] <br>";
        } else{
           $outputline.= "Port:$cpname[$i]_address:$caname[$i]_listen:$llaname[$i] <br>";
        }
    }
        print "&nbsp;$outputline<br>\n";
   }
   print "</td><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   for ($i=$halfcount; $i < $linecount; $i++) {
    $outputline = "<b>Remove</b><input type=\"radio\" name=\"linkslist\" value=\"remove_RiDiReCtOr_$cpname[$i]_RiDiReCtOr_$default[$i]_RiDiReCtOr_$caname[$i]_RiDiReCtOr_$llaname[$i]\"/>";
#    if ($caname[$i] eq "<DEFAULT>"){
    if ($default[$i] eq "YES"){
	if ($llaname[$i] eq "\"\""){
           $outputline.= "Port:$cpname[$i] <br>";
	} else{
	   $outputline.= "Port:$cpname[$i]_listen:$llaname[$i] <br>";
        }
    } else {

        if ($llaname[$i] eq "\"\""){
           $outputline.= "Port:$cpname[$i]_address:$caname[$i] <br>";
        } else{
           $outputline.= "Port:$cpname[$i]_address:$caname[$i]_listen:$llaname[$i] <br>";
        }
    }
        print "&nbsp;$outputline<br>\n";
   }
   print "</td></tr></tbody></table></table>";
   print "<br>";
}
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";

print "</p></form></font>";



#   output the bottom of the template

print_bottom();
