#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;

###########################################
#
#Begin of main section
#
###########################################
my ($time, $linecount, $halfcount, $i, @data, $remote_addr, $remote_port,
    @msname, $line, $outputline, $saveline, @retval, @contents);
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

print header;
print_top();

$time=localtime;
$i=0;
$linecount=0;
# 
#   SNAAdmin  command to get focal point info.
#
@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_focal_point`;

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/rem_fp.cgi\" method=\"post\">\n";
print "<br><b>  $time</b>";
print "<p>\n";

foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/ms_category/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @msname, $data[1];
            next;
            }
   }

$linecount=@msname;

if ($linecount == 0) {
    print "No Focal Point to remove";
    exit 0;
}
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
#
#  Build token for secure invocation of addaccess.cgi
#    
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
if ($linecount == 1) {
    print "<strong> Select Focal Point To Remove: </strong>\n";
    print "<br/>\n";
    print "<br/>\n";
    $outputline = "<b>Remove</b><input type=\"radio\" name=\"linkslist\" value=\"remove_$msname[$i]\"/>";
    $outputline.= " $msname[$i]  <br>";
    print "&nbsp;$outputline<br>\n";
} else  { # linecount is 2 or greater
#
#  Build table (2 columns) of link execution radio buttons
#
   print "</p><table><tr><td> <strong> Select Focal Point To Remove: </strong></td><tr>\n";
   print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
   print "<tbody><tr><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   if (($linecount % 2) == 1) { # if odd, add one to get proper split point
        $halfcount = ($linecount + 1) /2;
   } else {
        $halfcount = $linecount/2;
   }
   for ($i=0; $i < $halfcount; $i++) {
        $outputline = "<b>Remove</b><input type=\"radio\" name=\"linkslist\" value=\"remove_$msname[$i]\"/>";
        $outputline.= " $msname[$i] <br>";
        print "&nbsp;$outputline<br>\n";
   }
   print "</td><td nowrap=\"nowrap\" colspan=\"2\" valign=\"top\"><br>\n";
   for ($i=$halfcount; $i < $linecount; $i++) {
        $outputline = "<b> | Remove</b><input type=\"radio\" name=\"linkslist\" value=\"remove_$msname[$i]\"/>";
      $outputline.= " $msname[$i] <br>";
      print "&nbsp;$outputline<br>\n";
   }
   print "</td></tr></tbody></table></table>";
   print "<br>";
}
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";

print "</p></form></font>";



#   output the bottom of the template

print_bottom();



