#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_tp_name, $arg_lualias, $arg_userid, $arg_description, $arg_group, 
    $arg_type, $arg_env, $arg_path, $arg_arguments, $arg_stdin,  $arg_stdout, 
    $arg_stderr, $description, $lualias, $group, $userid, $path,  $arguments, 
    $stdin, $stdout, $stderr, $env, $time, $remote_addr, $remote_port, $line, 
    @data, @contents, @list, @retval);

$arg_tp_name="";
$arg_description="";
$arg_lualias="";
$arg_userid="";
$arg_group="";
$arg_type="QUEUED";
$arg_arguments="";
$arg_path="";
$arg_stdin="";
$arg_stdout="";
$arg_stderr="";
$arg_env="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/lu_alias/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addtpload.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #  * TP name
print "<tr><td>* TP name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"tp_name_loadinfo_unique\" maxlength=\"64\" value=\"$arg_tp_name\" required=\"required\" /oninput=\"value=value.replace(/[^a-zA-Z0-9:]/g,'')\"  /></td></tr>";
    
    #  LU alias
print "<tr><td>LU alias :</td> <td><select name=\"lualias\" class=\"rightAligned\" value=\"$arg_lualias\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@list) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    # * User ID
print "<tr><td>* User ID : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"userid\" maxlength=\"64\" value=\"$arg_userid\" required=\"required\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_]/g,'')\" /></td></tr>";
    
    #  Group ID
print "<tr><td>Group ID :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"group\" maxlength=\"64\" value=\"$arg_group\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_]/g,'')\" /></td></tr>";
    
    #   Load Type
print "<tr><td>Load Type </td> <td> <select name=\"type\" class=\"rightAligned\" value=\"$arg_type\" >  ";
print "<option value=\"QUEUED\" selected=\"selected\">QUEUED</option> ";
print "<option value=\"QUEUED-BROADCAST\">QUEUED-BROADCAST</option> ";
print "<option value=\"NON-QUEUED\">NON-QUEUED</option></select></td></tr>";
    
    #   Path
print "<tr><td>Path : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"path\" maxlength=\"255\" value=\"$arg_path\" /oninput=\"value=value.replace(/[^a-zA-Z0-9._-#@\$\/]/g,'')\" /></td></tr>";
    
    #   Arguments
print "<tr><td>Arguments : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"arguments\" maxlength=\"255\" value=\"$arg_arguments\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #   stdin Path
print "<tr><td>stdin Path : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"stdin\" maxlength=\"255\" value=\"$arg_stdin\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!.:@\/\$]/g,'')\" /></td></tr>";
    
    #   stdout Path
print "<tr><td>stdout Path  : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"stdout\" maxlength=\"255\" value=\"$arg_stdout\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!.:@\/\$]/g,'')\" /></td></tr>";
    
    #   stderr Path
print "<tr><td>stderr Path : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"stderr\" maxlength=\"255\" value=\"$arg_stderr\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!.:@\/\$]/g,'')\" /></td></tr>";
    
    #   Environment
print "<tr><td>Environment : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"env\" maxlength=\"255\" value=\"$arg_env\" /oninput=\"value=value.replace(/[^A-Z0-9_-#!.:@\$]/g,'')\" /></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

