#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_tp_name, $arg_list_name, $arg_description, $arg_conv_type, 
    $arg_security_rqd, $arg_sync_level, $arg_pip_allowed, $description, 
    $list_name, $time, $remote_addr, $remote_port, $line, @data, @contents, 
    @list, @retval);

$arg_tp_name="";
$arg_description="";
$arg_list_name="";
$arg_security_rqd="NO";
$arg_conv_type="EITHER";
$arg_sync_level="SYNCPT_NEGOTIABLE";
$arg_pip_allowed="YES";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}   
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_security_access_list`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/list_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        push @list, $data[1];
        next;
    }
}
    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addtp.cgi\" method=\"post\">\n";

print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    #  * Name
print "<tr><td>* Name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"tp_name_unique\" maxlength=\"64\" value=\"$arg_tp_name\" required=\"required\" /oninput=\"value=value.replace(/:@#[^a-zA-Z0-9]/g,'')\" /></td></tr>";
    
    #  Description
print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. :@\(\)\$]/g,'')\" /></td></tr>";
    
    #  Security Access List name
print "<tr><td>Security Access List name :</td> <td><select name=\"list_name\" class=\"rightAligned\" value=\"$arg_list_name\" >  ";
print "<option value=\"\"></option> ";
foreach $line (@list) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #  Conversation type(s) supported
print "<tr><td>Conversation type(s) supported : </td> <td><select name=\"conv_type\" class=\"rightAligned\" value=\"$arg_conv_type\" >  ";
print "<option value=\"EITHER\" selected=\"selected\">EITHER</option> ";
print "<option value=\"BASIC\">BASIC</option>";
print "<option value=\"MAPPED\">MAPPED</option></select></td></tr>";
    
    #   Conversation security is required?
print "<tr><td> Conversation security is required ? </td> <td> <select name=\"security_rqd\" class=\"rightAligned\" value=\"$arg_security_rqd\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option></select></td></tr>";
   
    #   Synchronization level supported?
print "<tr><td>Synchronization level supported ? </td> <td><select name=\"sync_level\" class=\"rightAligned\" value=\"$arg_sync_level\" >  ";
print "<option value=\"SYNCPT_NEGOTIABLE\" selected=\"selected\">SYNCPT_NEGOTIABLE</option> ";
print "<option value=\"NONE\">NONE</option> ";
print "<option value=\"CONFIRM_SYNC_LEVEL\">CONFIRM_SYNC_LEVEL</option> ";
print "<option value=\"EITHER\">EITHER</option> ";
print "<option value=\"SYNCPT_REQUIRED\">SYNCPT_REQUIRED</option></select></td></tr>";
    
    #   Program Initialization Parameters (PIP) allowed?
print "<tr><td>Program Initialization Parameters (PIP) allowed ?</td> <td> <select name=\"pip_allowed\" class=\"rightAligned\" value=\"$arg_pip_allowed\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option></select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
  
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;
 

