#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_default_record, $arg_client_address, $arg_client_port, 
    $arg_listen_local_address, $arg_description, $arg_host_address, 
    $arg_host_port, $arg_host_ssl_enabled, $arg_serv_conn_security_level, 
    $arg_cli_ssl_enabled, $arg_cli_conn_security_levell, $client_address, 
    $listen_local_address, $description, $time, $remote_addr, $remote_port,
    $line, @data, @contents, @retval);

$arg_client_port="";
$arg_default_record="YES";
$arg_client_address="";
$arg_client_port="";
$arg_listen_local_address="";
$arg_host_address="";
$arg_host_port="";
$arg_cli_ssl_enabled="NO";
$arg_cli_conn_security_levell="SSL_AUTHENTICATE_MIN";
$arg_host_ssl_enabled="NO";
$arg_serv_conn_security_level="SSL_AUTHENTICATE_MIN";
$arg_description="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
} 
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addtnredirect.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Allow access to all TN clients?
print "<tr> <td>Allow access to all TN clients ? </td> <td><select name=\"default_record\"  class=\"rightAligned\" value=\"$arg_default_record\" >  ";
print "<option value=\"NO\">NO</option> ";
print "<option value=\"YES\" selected=\"selected\">YES</option> </select></td></tr>";

print "<tr> <td> -----------</td> </tr>";
    
print "<tr> <td>If NO, </td> </tr>";
    
    #    Client address or name
print "<tr> <td> Client address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"client_address\"  maxlength=\"255\" value=\"$arg_client_address\" oninput=\"value=value.replace(/[^0-9a-zA-Z_-:.]/g,'')\" /></td></tr>";

print "<tr> <td> -----------</td> </tr>";
    
    #   * Client port number
print "<tr> <td>* Client port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"client_port_unique\"  maxlength=\"5\" value=\"$arg_client_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\" /></td></tr>";
    
    #   Local listen address
print "<tr> <td> Local listen address : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"listen_local_address\"  maxlength=\"45\" value=\"$arg_listen_local_address\"  oninput=\"value=value.replace(/[^0-9a-fA-F:.]/g,'')\" /></td></tr>";
   
    #    * Host address or name
print "<tr> <td>* Host address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"host_address\"  maxlength=\"255\" value=\"$arg_host_address\" required=\"required\" oninput=\"value=value.replace(/[^0-9a-zA-Z_-:.]/g,'')\" /></td></tr>";
    
    #   * Host port number
print "<tr> <td>* Host port number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"host_port\"  maxlength=\"5\" value=\"$arg_host_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\" /></td></tr>";
    
    #   SSL enabled on client connection?
print "<tr><td>SSL enabled on client connection ?  </td> <td><select name=\"cli_ssl_enabled\"  class=\"rightAligned\" value=\"$arg_cli_ssl_enabled\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\">YES</option> ";
print "<option value=\"YES_WITH_CLI_AUTH\">YES_WITH_CLI_AUTH</option> </select></td></tr>";
    
print "<tr> <td> If YES or YES_WITH_CLI_AUTH, </td> </tr>";
    
    #   Security level on client connection
print "<tr><td>Security level on client connection : </td> <td><select name=\"cli_conn_security_levell\"  class=\"rightAligned\" value=\"$arg_cli_conn_security_levell\" >  ";
print "<option value=\"SSL_AUTHENTICATE_MIN\" selected=\"selected\">SSL_AUTHENTICATE_MIN</option> ";
print "<option value=\"SSL_AUTHENTICATE_ONLY\">SSL_AUTHENTICATE_ONLY</option> ";
print "<option value=\"SSL_40_BIT_MIN\">SSL_40_BIT_MIN</option> ";
print "<option value=\"SSL_56_BIT_MIN\">SSL_56_BIT_MIN</option> ";
print "<option value=\"SSL_128_BIT_MIN\">SSL_128_BIT_MIN</option> ";
print "<option value=\"SSL_168_BIT_MIN\">SSL_168_BIT_MIN</option> ";
print "<option value=\"SSL_256_BIT_MIN\">SSL_256_BIT_MIN</option> </select></td></tr>";
    
    # SSL enabled on host connection?
print "<tr><td>SSL enabled on host connection ? </td> <td><select name=\"host_ssl_enabled\"  class=\"rightAligned\" value=\"$arg_host_ssl_enabled\" >  ";
print "<option value=\"NO\" selected=\"selected\">NO</option> ";
print "<option value=\"YES\" >YES</option> </select></td></tr>";
    
print "<tr> <td> If YES, </td> </tr>";
    #   Security level on host connection
print "<tr><td>Security level on host connection : </td> <td><select name=\"serv_conn_security_level\"  class=\"rightAligned\" value=\"$arg_serv_conn_security_level\" >  ";
print "<option value=\"SSL_AUTHENTICATE_MIN\" selected=\"selected\">SSL_AUTHENTICATE_MIN</option> ";
print "<option value=\"SSL_AUTHENTICATE_ONLY\">SSL_AUTHENTICATE_ONLY</option> ";
print "<option value=\"SSL_40_BIT_MIN\">SSL_40_BIT_MIN</option> ";
print "<option value=\"SSL_56_BIT_MIN\">SSL_56_BIT_MIN</option> ";
print "<option value=\"SSL_128_BIT_MIN\">SSL_128_BIT_MIN</option> ";
print "<option value=\"SSL_168_BIT_MIN\">SSL_168_BIT_MIN</option> ";
print "<option value=\"SSL_256_BIT_MIN\">SSL_256_BIT_MIN</option> </select></td></tr>";
    
    #    Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";   

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

