#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_dcas_server, $arg_dcas_port, $arg_enabled, $dcas_port,
    $time, $remote_addr, $remote_port, $line, @data, @contents, @retval);

$arg_dcas_server="";
$arg_dcas_port="8990";
$arg_enabled="YES";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}        
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn3270_express_logon`;
    
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
       
    if ($line=~m/dcas_server/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;
        $arg_dcas_server = $data[1];
        next;
    } elsif ($line=~m/dcas_port/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;
        $arg_dcas_port = $data[1];
        next;
    } elsif ($line=~m/enabled/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;
        $arg_enabled = $data[1];
        next;
    } else {
        next;
    }
        
}

print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addtn_el.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   * DCAS Server Address or Name
print "<tr> <td>* DCAS Server Address or Name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dcas_server_unique\"  maxlength=\"255\" value=\"$arg_dcas_server\" required=\"required\" oninput=\"value=value.replace(/[^0-9a-zA-Z.:_-]/g,'')\" /></td></tr>";
    
    #    DCAS Server Port number
print "<tr> <td>DCAS Server Port number(1-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"dcas_port\"  maxlength=\"5\" value=\"$arg_dcas_port\" oninput=\"value=value.replace(/[^\d]/g,'')\" /></td></tr>";
    
    #   Enable Express Logon?
print "<tr> <td>Enable Express Logon ? </td> <td><select name=\"enabled\"  class=\"rightAligned\" value=\"$arg_enabled\" >  ";
print "<option value=\"YES\" selected=\"selected\">YES</option> ";
print "<option value=\"NO\">NO</option> </select></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";
    
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0; 

