#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_display_lu_name, $arg_description, $arg_printer_lu_name, 
    $description, $lu_name, $len, $time, $remote_addr, $remote_port, $line, 
    @data, @contents, @dlist, @plist, @retval);

$arg_display_lu_name="";
$arg_description="";
$arg_printer_lu_name="";
$arg_display_lu_name="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}        
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3 -d`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/^lu_name/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        $lu_name=$data[1];
        next;
    }elsif ($line=~m/lu_model/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
        if ($data[1]=~m/3270_DISPLAY/ || $data[1]=~m/UNKNOWN/ ) {
            push @dlist, $lu_name;
        }elsif($data[1] =~/PRINTER/){
            push @plist, $lu_name;
        }
        next;
    }
}
$len=@dlist;
if($len eq 0){
    print "<br> Display LU should be defined before define TN Association. ";
    exit 1;
}
    
$len=@plist;
if($len eq 0){
     print "<br> Printer LU should be defined before define TN Association.  ";
     exit 1;
}
    
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/addtnass.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #    Description
print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_-#!. @\(\)\$]/g,'')\" /></td></tr>";
    
  #  * Display LU
print "<tr><td>* Display LU :</td> <td><select name=\"display_lu_name_unique\" class=\"rightAligned\" value=\"$arg_display_lu_name\" >  ";
foreach $line (@dlist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
    
    #   * Printer LU
print "<tr> <td>* Printer LU :</td> <td><select name=\"printer_lu_name\" class=\"rightAligned\" value=\"$arg_printer_lu_name\" >  ";
foreach $line (@plist) {
    print "<option value=\"$line\">$line</option> ";
}
print "</select></td></tr>";
   
print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>"; 
    
print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

