#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018, 2025 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;
#
#   Define variables needed for token
#
our ($up_time, $hash);
require "./webadmin_bld_token.pl";

###########################################
#
# Begin of main section
#
###########################################
my ($arg, $arg_auth_type, $arg_ldap_addr, $arg_ldap_port, $arg_ldap_user, 
    $arg_ldap_password, $ldap_addr, $ldap_port, $ldap_user, $ldap_password, 
    $time, $remote_addr, $remote_port, $line, @data, @contents, @retval);

$arg_auth_type="";
$arg_auth_type="LOCAL_ONLY";
$arg_ldap_addr="";
$arg_ldap_port="";
$arg_ldap_user="";
$arg_ldap_password="";
#
#  Get IP and port of client's socket connection
#
$remote_addr=$ENV{REMOTE_ADDR};
#$remote_port=$ENV{REMOTE_PORT}; Change to use HTTP_USER_AGENT env. var
$remote_port=$ENV{HTTP_USER_AGENT};
#
@retval = build_token($remote_addr, $remote_port);
$up_time = $retval[0];
$hash = $retval[1];
if ($up_time eq "0000") {
    print "<b>Failed to access the node. \n</b>";
    exit -1;
}
    
@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn3270_ssl_ldap`;

foreach $line (@contents) {
   next if ($line=~m/-----/);   # Do not display seperaters
    
    if ($line=~m/auth_type/) {
        @data = split(/=/,$line);
        $data[1]=~s/^\s+|\s+$//g;
        $arg_auth_type = $data[1];
        next;
    } elsif ($line=~m/ldap_addr/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+//;
      $data[1]=~s/\s+$//;
      $arg_ldap_addr = $data[1];
      next;
    } elsif ($line=~m/ldap_user/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_ldap_user = $data[1];
      next;
    } elsif ($line=~m/ldap_port/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_ldap_port = $data[1];
      next;
    } elsif ($line=~m/ldap_password/) {
      @data = split(/=/,$line);
      $data[1]=~s/^\s+|\s+$//g;
      $arg_ldap_password = $data[1];
      next;         
    } else {
      next;
    }

}
print "<font face=\"Times New Roman, Helvetica\">";
print "<form action= \"/cscbin/add_ldap.cgi\" method=\"post\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
print "<tbody> ";
    
    #   Specifies the type of authorization
print "<tr> <td>The type of authorization :</td> <td><select name=\"auth_type_unique\"  class=\"rightAligned\" value=\"$arg_auth_type\" >  ";
print "<option value=\"LOCAL_ONLY\" selected=\"selected\">LOCAL_ONLY</option> ";
print "<option value=\"LOCAL_X500\">LOCAL_X500</option> </select></td></tr>";
    
print "<tr> <td>If LOCAL_X500, </td> </tr>";
    
    #    LDAP Address or name
print "<tr> <td> LDAP Address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ldap_addr\"  maxlength=\"255\" value=\"$arg_ldap_addr\" oninput=\"value=value.replace(/[^0-9a-zA-Z.:_-]/g,'')\" /></td></tr>";
    
    #   LDAP Port
print "<tr> <td>LDAP Port : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ldap_port\"  maxlength=\"10\" value=\"$arg_ldap_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    
    #   LDAP User
print "<tr> <td> LDAP User : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ldap_user\"  maxlength=\"1024\" value=\"$arg_ldap_user\" oninput=\"value=value.replace(/[^0-9a-zA-Z._#]/g,'')\" >  ";
   
    #   LDAP Password
print "<tr> <td>LDAP Password :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"ldap_password\"  maxlength=\"128\"  value=\"$arg_ldap_password\" /oninput=\"value=value.replace(/[^a-zA-Z0-9_#!.@*\-+\(\)\$]/g,'')\" /></td></tr>";

print "<input type=\"hidden\" name=\"up_time\" value=\"$up_time\"/>";

print "<input type=\"hidden\" name=\"hash\" value=\"$hash\"/>";

print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
print "</tbody> ";
print "</table> ";
print "</form>";
print "<p>";

exit 0;

